/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.model.ExtraParamName;
import software.amazon.awssdk.services.route53domains.transform.ExtraParamMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExtraParam
implements StructuredPojo,
ToCopyableBuilder<Builder, ExtraParam> {
    private final String name;
    private final String value;

    private ExtraParam(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    public ExtraParamName name() {
        return ExtraParamName.fromValue(this.name);
    }

    public String nameString() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nameString() == null ? 0 : this.nameString().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtraParam)) {
            return false;
        }
        ExtraParam other = (ExtraParam)obj;
        if (other.nameString() == null ^ this.nameString() == null) {
            return false;
        }
        if (other.nameString() != null && !other.nameString().equals(this.nameString())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        return other.value() == null || other.value().equals(this.value());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nameString() != null) {
            sb.append("Name: ").append(this.nameString()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.nameString()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExtraParamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtraParam model) {
            this.name(model.name);
            this.value(model.value);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ExtraParamName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public ExtraParam build() {
            return new ExtraParam(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExtraParam> {
        public Builder name(String var1);

        public Builder name(ExtraParamName var1);

        public Builder value(String var1);
    }
}

