/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CheckDomainAvailabilityRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CheckDomainAvailabilityRequest> {
    private final String domainName;
    private final String idnLangCode;

    private CheckDomainAvailabilityRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.idnLangCode = builder.idnLangCode;
    }

    public String domainName() {
        return this.domainName;
    }

    public String idnLangCode() {
        return this.idnLangCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.idnLangCode() == null ? 0 : this.idnLangCode().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainAvailabilityRequest)) {
            return false;
        }
        CheckDomainAvailabilityRequest other = (CheckDomainAvailabilityRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.idnLangCode() == null ^ this.idnLangCode() == null) {
            return false;
        }
        return other.idnLangCode() == null || other.idnLangCode().equals(this.idnLangCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.idnLangCode() != null) {
            sb.append("IdnLangCode: ").append(this.idnLangCode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "IdnLangCode": {
                return Optional.of(clazz.cast(this.idnLangCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String idnLangCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainAvailabilityRequest model) {
            this.domainName(model.domainName);
            this.idnLangCode(model.idnLangCode);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getIdnLangCode() {
            return this.idnLangCode;
        }

        @Override
        public final Builder idnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
            return this;
        }

        public final void setIdnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
        }

        public CheckDomainAvailabilityRequest build() {
            return new CheckDomainAvailabilityRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CheckDomainAvailabilityRequest> {
        public Builder domainName(String var1);

        public Builder idnLangCode(String var1);
    }
}

