/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RRType {
    SOA("SOA"),
    A("A"),
    TXT("TXT"),
    NS("NS"),
    CNAME("CNAME"),
    MX("MX"),
    NAPTR("NAPTR"),
    PTR("PTR"),
    SRV("SRV"),
    SPF("SPF"),
    AAAA("AAAA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RRType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RRType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RRType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RRType> knownValues() {
        return Stream.of(RRType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

