/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTrafficPolicyInstancesByPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListTrafficPolicyInstancesByPolicyRequest> {
    private final String trafficPolicyId;
    private final Integer trafficPolicyVersion;
    private final String hostedZoneIdMarker;
    private final String trafficPolicyInstanceNameMarker;
    private final String trafficPolicyInstanceTypeMarker;
    private final String maxItems;

    private ListTrafficPolicyInstancesByPolicyRequest(BuilderImpl builder) {
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
        this.hostedZoneIdMarker = builder.hostedZoneIdMarker;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.maxItems = builder.maxItems;
    }

    public String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public Integer trafficPolicyVersion() {
        return this.trafficPolicyVersion;
    }

    public String hostedZoneIdMarker() {
        return this.hostedZoneIdMarker;
    }

    public String trafficPolicyInstanceNameMarker() {
        return this.trafficPolicyInstanceNameMarker;
    }

    public RRType trafficPolicyInstanceTypeMarker() {
        return RRType.fromValue(this.trafficPolicyInstanceTypeMarker);
    }

    public String trafficPolicyInstanceTypeMarkerString() {
        return this.trafficPolicyInstanceTypeMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.trafficPolicyId() == null ? 0 : this.trafficPolicyId().hashCode());
        hashCode = 31 * hashCode + (this.trafficPolicyVersion() == null ? 0 : this.trafficPolicyVersion().hashCode());
        hashCode = 31 * hashCode + (this.hostedZoneIdMarker() == null ? 0 : this.hostedZoneIdMarker().hashCode());
        hashCode = 31 * hashCode + (this.trafficPolicyInstanceNameMarker() == null ? 0 : this.trafficPolicyInstanceNameMarker().hashCode());
        hashCode = 31 * hashCode + (this.trafficPolicyInstanceTypeMarkerString() == null ? 0 : this.trafficPolicyInstanceTypeMarkerString().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesByPolicyRequest)) {
            return false;
        }
        ListTrafficPolicyInstancesByPolicyRequest other = (ListTrafficPolicyInstancesByPolicyRequest)((Object)obj);
        if (other.trafficPolicyId() == null ^ this.trafficPolicyId() == null) {
            return false;
        }
        if (other.trafficPolicyId() != null && !other.trafficPolicyId().equals(this.trafficPolicyId())) {
            return false;
        }
        if (other.trafficPolicyVersion() == null ^ this.trafficPolicyVersion() == null) {
            return false;
        }
        if (other.trafficPolicyVersion() != null && !other.trafficPolicyVersion().equals(this.trafficPolicyVersion())) {
            return false;
        }
        if (other.hostedZoneIdMarker() == null ^ this.hostedZoneIdMarker() == null) {
            return false;
        }
        if (other.hostedZoneIdMarker() != null && !other.hostedZoneIdMarker().equals(this.hostedZoneIdMarker())) {
            return false;
        }
        if (other.trafficPolicyInstanceNameMarker() == null ^ this.trafficPolicyInstanceNameMarker() == null) {
            return false;
        }
        if (other.trafficPolicyInstanceNameMarker() != null && !other.trafficPolicyInstanceNameMarker().equals(this.trafficPolicyInstanceNameMarker())) {
            return false;
        }
        if (other.trafficPolicyInstanceTypeMarkerString() == null ^ this.trafficPolicyInstanceTypeMarkerString() == null) {
            return false;
        }
        if (other.trafficPolicyInstanceTypeMarkerString() != null && !other.trafficPolicyInstanceTypeMarkerString().equals(this.trafficPolicyInstanceTypeMarkerString())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.trafficPolicyId() != null) {
            sb.append("TrafficPolicyId: ").append(this.trafficPolicyId()).append(",");
        }
        if (this.trafficPolicyVersion() != null) {
            sb.append("TrafficPolicyVersion: ").append(this.trafficPolicyVersion()).append(",");
        }
        if (this.hostedZoneIdMarker() != null) {
            sb.append("HostedZoneIdMarker: ").append(this.hostedZoneIdMarker()).append(",");
        }
        if (this.trafficPolicyInstanceNameMarker() != null) {
            sb.append("TrafficPolicyInstanceNameMarker: ").append(this.trafficPolicyInstanceNameMarker()).append(",");
        }
        if (this.trafficPolicyInstanceTypeMarkerString() != null) {
            sb.append("TrafficPolicyInstanceTypeMarker: ").append(this.trafficPolicyInstanceTypeMarkerString()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicyId": {
                return Optional.of(clazz.cast(this.trafficPolicyId()));
            }
            case "TrafficPolicyVersion": {
                return Optional.of(clazz.cast(this.trafficPolicyVersion()));
            }
            case "HostedZoneIdMarker": {
                return Optional.of(clazz.cast(this.hostedZoneIdMarker()));
            }
            case "TrafficPolicyInstanceNameMarker": {
                return Optional.of(clazz.cast(this.trafficPolicyInstanceNameMarker()));
            }
            case "TrafficPolicyInstanceTypeMarker": {
                return Optional.of(clazz.cast(this.trafficPolicyInstanceTypeMarkerString()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String trafficPolicyId;
        private Integer trafficPolicyVersion;
        private String hostedZoneIdMarker;
        private String trafficPolicyInstanceNameMarker;
        private String trafficPolicyInstanceTypeMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesByPolicyRequest model) {
            this.trafficPolicyId(model.trafficPolicyId);
            this.trafficPolicyVersion(model.trafficPolicyVersion);
            this.hostedZoneIdMarker(model.hostedZoneIdMarker);
            this.trafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            this.trafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            this.maxItems(model.maxItems);
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        public final Integer getTrafficPolicyVersion() {
            return this.trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        public final String getHostedZoneIdMarker() {
            return this.hostedZoneIdMarker;
        }

        @Override
        public final Builder hostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
            return this;
        }

        public final void setHostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return this.trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        public final String getTrafficPolicyInstanceTypeMarker() {
            return this.trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker.toString());
            return this;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListTrafficPolicyInstancesByPolicyRequest build() {
            return new ListTrafficPolicyInstancesByPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTrafficPolicyInstancesByPolicyRequest> {
        public Builder trafficPolicyId(String var1);

        public Builder trafficPolicyVersion(Integer var1);

        public Builder hostedZoneIdMarker(String var1);

        public Builder trafficPolicyInstanceNameMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(RRType var1);

        public Builder maxItems(String var1);
    }
}

