/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.TagResourceIdListCopier;
import software.amazon.awssdk.services.route53.model.TagResourceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagsForResourcesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListTagsForResourcesRequest> {
    private final String resourceType;
    private final List<String> resourceIds;

    private ListTagsForResourcesRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceIds = builder.resourceIds;
    }

    public TagResourceType resourceType() {
        return TagResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public List<String> resourceIds() {
        return this.resourceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceTypeString() == null ? 0 : this.resourceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.resourceIds() == null ? 0 : this.resourceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourcesRequest)) {
            return false;
        }
        ListTagsForResourcesRequest other = (ListTagsForResourcesRequest)((Object)obj);
        if (other.resourceTypeString() == null ^ this.resourceTypeString() == null) {
            return false;
        }
        if (other.resourceTypeString() != null && !other.resourceTypeString().equals(this.resourceTypeString())) {
            return false;
        }
        if (other.resourceIds() == null ^ this.resourceIds() == null) {
            return false;
        }
        return other.resourceIds() == null || other.resourceIds().equals(this.resourceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceTypeString() != null) {
            sb.append("ResourceType: ").append(this.resourceTypeString()).append(",");
        }
        if (this.resourceIds() != null) {
            sb.append("ResourceIds: ").append(this.resourceIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "ResourceIds": {
                return Optional.of(clazz.cast(this.resourceIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private List<String> resourceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourcesRequest model) {
            this.resourceType(model.resourceType);
            this.resourceIds(model.resourceIds);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getResourceIds() {
            return this.resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = TagResourceIdListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = TagResourceIdListCopier.copy(resourceIds);
        }

        public ListTagsForResourcesRequest build() {
            return new ListTagsForResourcesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTagsForResourcesRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(TagResourceType var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);
    }
}

