/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.DelegationSet;
import software.amazon.awssdk.services.route53.model.DelegationSetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListReusableDelegationSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListReusableDelegationSetsResponse> {
    private final List<DelegationSet> delegationSets;
    private final String marker;
    private final Boolean isTruncated;
    private final String nextMarker;
    private final String maxItems;

    private ListReusableDelegationSetsResponse(BuilderImpl builder) {
        this.delegationSets = builder.delegationSets;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    public List<DelegationSet> delegationSets() {
        return this.delegationSets;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.delegationSets() == null ? 0 : this.delegationSets().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReusableDelegationSetsResponse)) {
            return false;
        }
        ListReusableDelegationSetsResponse other = (ListReusableDelegationSetsResponse)((Object)obj);
        if (other.delegationSets() == null ^ this.delegationSets() == null) {
            return false;
        }
        if (other.delegationSets() != null && !other.delegationSets().equals(this.delegationSets())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.delegationSets() != null) {
            sb.append("DelegationSets: ").append(this.delegationSets()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DelegationSets": {
                return Optional.of(clazz.cast(this.delegationSets()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DelegationSet> delegationSets;
        private String marker;
        private Boolean isTruncated;
        private String nextMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReusableDelegationSetsResponse model) {
            this.delegationSets(model.delegationSets);
            this.marker(model.marker);
            this.isTruncated(model.isTruncated);
            this.nextMarker(model.nextMarker);
            this.maxItems(model.maxItems);
        }

        public final Collection<DelegationSet.Builder> getDelegationSets() {
            return this.delegationSets != null ? (Collection)this.delegationSets.stream().map(DelegationSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder delegationSets(Collection<DelegationSet> delegationSets) {
            this.delegationSets = DelegationSetsCopier.copy(delegationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegationSets(DelegationSet ... delegationSets) {
            this.delegationSets(Arrays.asList(delegationSets));
            return this;
        }

        public final void setDelegationSets(Collection<DelegationSet.BuilderImpl> delegationSets) {
            this.delegationSets = DelegationSetsCopier.copyFromBuilder(delegationSets);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListReusableDelegationSetsResponse build() {
            return new ListReusableDelegationSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListReusableDelegationSetsResponse> {
        public Builder delegationSets(Collection<DelegationSet> var1);

        public Builder delegationSets(DelegationSet ... var1);

        public Builder marker(String var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextMarker(String var1);

        public Builder maxItems(String var1);
    }
}

