/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.ChangeInfo;
import software.amazon.awssdk.services.route53.model.DelegationSet;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateHostedZoneResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateHostedZoneResponse> {
    private final HostedZone hostedZone;
    private final ChangeInfo changeInfo;
    private final DelegationSet delegationSet;
    private final VPC vpc;
    private final String location;

    private CreateHostedZoneResponse(BuilderImpl builder) {
        this.hostedZone = builder.hostedZone;
        this.changeInfo = builder.changeInfo;
        this.delegationSet = builder.delegationSet;
        this.vpc = builder.vpc;
        this.location = builder.location;
    }

    public HostedZone hostedZone() {
        return this.hostedZone;
    }

    public ChangeInfo changeInfo() {
        return this.changeInfo;
    }

    public DelegationSet delegationSet() {
        return this.delegationSet;
    }

    public VPC vpc() {
        return this.vpc;
    }

    public String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostedZone() == null ? 0 : this.hostedZone().hashCode());
        hashCode = 31 * hashCode + (this.changeInfo() == null ? 0 : this.changeInfo().hashCode());
        hashCode = 31 * hashCode + (this.delegationSet() == null ? 0 : this.delegationSet().hashCode());
        hashCode = 31 * hashCode + (this.vpc() == null ? 0 : this.vpc().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostedZoneResponse)) {
            return false;
        }
        CreateHostedZoneResponse other = (CreateHostedZoneResponse)((Object)obj);
        if (other.hostedZone() == null ^ this.hostedZone() == null) {
            return false;
        }
        if (other.hostedZone() != null && !other.hostedZone().equals(this.hostedZone())) {
            return false;
        }
        if (other.changeInfo() == null ^ this.changeInfo() == null) {
            return false;
        }
        if (other.changeInfo() != null && !other.changeInfo().equals(this.changeInfo())) {
            return false;
        }
        if (other.delegationSet() == null ^ this.delegationSet() == null) {
            return false;
        }
        if (other.delegationSet() != null && !other.delegationSet().equals(this.delegationSet())) {
            return false;
        }
        if (other.vpc() == null ^ this.vpc() == null) {
            return false;
        }
        if (other.vpc() != null && !other.vpc().equals(this.vpc())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        return other.location() == null || other.location().equals(this.location());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostedZone() != null) {
            sb.append("HostedZone: ").append(this.hostedZone()).append(",");
        }
        if (this.changeInfo() != null) {
            sb.append("ChangeInfo: ").append(this.changeInfo()).append(",");
        }
        if (this.delegationSet() != null) {
            sb.append("DelegationSet: ").append(this.delegationSet()).append(",");
        }
        if (this.vpc() != null) {
            sb.append("VPC: ").append(this.vpc()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZone": {
                return Optional.of(clazz.cast(this.hostedZone()));
            }
            case "ChangeInfo": {
                return Optional.of(clazz.cast(this.changeInfo()));
            }
            case "DelegationSet": {
                return Optional.of(clazz.cast(this.delegationSet()));
            }
            case "VPC": {
                return Optional.of(clazz.cast(this.vpc()));
            }
            case "Location": {
                return Optional.of(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private HostedZone hostedZone;
        private ChangeInfo changeInfo;
        private DelegationSet delegationSet;
        private VPC vpc;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostedZoneResponse model) {
            this.hostedZone(model.hostedZone);
            this.changeInfo(model.changeInfo);
            this.delegationSet(model.delegationSet);
            this.vpc(model.vpc);
            this.location(model.location);
        }

        public final HostedZone.Builder getHostedZone() {
            return this.hostedZone != null ? this.hostedZone.toBuilder() : null;
        }

        @Override
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final void setHostedZone(HostedZone.BuilderImpl hostedZone) {
            this.hostedZone = hostedZone != null ? hostedZone.build() : null;
        }

        public final ChangeInfo.Builder getChangeInfo() {
            return this.changeInfo != null ? this.changeInfo.toBuilder() : null;
        }

        @Override
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        public final void setChangeInfo(ChangeInfo.BuilderImpl changeInfo) {
            this.changeInfo = changeInfo != null ? changeInfo.build() : null;
        }

        public final DelegationSet.Builder getDelegationSet() {
            return this.delegationSet != null ? this.delegationSet.toBuilder() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        public final VPC.Builder getVPC() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public CreateHostedZoneResponse build() {
            return new CreateHostedZoneResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateHostedZoneResponse> {
        public Builder hostedZone(HostedZone var1);

        public Builder changeInfo(ChangeInfo var1);

        public Builder delegationSet(DelegationSet var1);

        public Builder vpc(VPC var1);

        public Builder location(String var1);
    }
}

