/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.HealthCheckConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateHealthCheckRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateHealthCheckRequest> {
    private final String callerReference;
    private final HealthCheckConfig healthCheckConfig;

    private CreateHealthCheckRequest(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.healthCheckConfig = builder.healthCheckConfig;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.callerReference() == null ? 0 : this.callerReference().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckConfig() == null ? 0 : this.healthCheckConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHealthCheckRequest)) {
            return false;
        }
        CreateHealthCheckRequest other = (CreateHealthCheckRequest)((Object)obj);
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.healthCheckConfig() == null ^ this.healthCheckConfig() == null) {
            return false;
        }
        return other.healthCheckConfig() == null || other.healthCheckConfig().equals(this.healthCheckConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.callerReference() != null) {
            sb.append("CallerReference: ").append(this.callerReference()).append(",");
        }
        if (this.healthCheckConfig() != null) {
            sb.append("HealthCheckConfig: ").append(this.healthCheckConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.of(clazz.cast(this.callerReference()));
            }
            case "HealthCheckConfig": {
                return Optional.of(clazz.cast(this.healthCheckConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String callerReference;
        private HealthCheckConfig healthCheckConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHealthCheckRequest model) {
            this.callerReference(model.callerReference);
            this.healthCheckConfig(model.healthCheckConfig);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return this.healthCheckConfig != null ? this.healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public CreateHealthCheckRequest build() {
            return new CreateHealthCheckRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateHealthCheckRequest> {
        public Builder callerReference(String var1);

        public Builder healthCheckConfig(HealthCheckConfig var1);
    }
}

