/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.ChangeBatch;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChangeResourceRecordSetsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ChangeResourceRecordSetsRequest> {
    private final String hostedZoneId;
    private final ChangeBatch changeBatch;

    private ChangeResourceRecordSetsRequest(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.changeBatch = builder.changeBatch;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public ChangeBatch changeBatch() {
        return this.changeBatch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostedZoneId() == null ? 0 : this.hostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.changeBatch() == null ? 0 : this.changeBatch().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeResourceRecordSetsRequest)) {
            return false;
        }
        ChangeResourceRecordSetsRequest other = (ChangeResourceRecordSetsRequest)((Object)obj);
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.changeBatch() == null ^ this.changeBatch() == null) {
            return false;
        }
        return other.changeBatch() == null || other.changeBatch().equals(this.changeBatch());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (this.changeBatch() != null) {
            sb.append("ChangeBatch: ").append(this.changeBatch()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
            case "ChangeBatch": {
                return Optional.of(clazz.cast(this.changeBatch()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private ChangeBatch changeBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeResourceRecordSetsRequest model) {
            this.hostedZoneId(model.hostedZoneId);
            this.changeBatch(model.changeBatch);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final ChangeBatch.Builder getChangeBatch() {
            return this.changeBatch != null ? this.changeBatch.toBuilder() : null;
        }

        @Override
        public final Builder changeBatch(ChangeBatch changeBatch) {
            this.changeBatch = changeBatch;
            return this;
        }

        public final void setChangeBatch(ChangeBatch.BuilderImpl changeBatch) {
            this.changeBatch = changeBatch != null ? changeBatch.build() : null;
        }

        public ChangeResourceRecordSetsRequest build() {
            return new ChangeResourceRecordSetsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChangeResourceRecordSetsRequest> {
        public Builder hostedZoneId(String var1);

        public Builder changeBatch(ChangeBatch var1);
    }
}

