/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.HostedZoneConfig;

public class HostedZoneConfigUnmarshaller
implements Unmarshaller<HostedZoneConfig, StaxUnmarshallerContext> {
    private static final HostedZoneConfigUnmarshaller INSTANCE = new HostedZoneConfigUnmarshaller();

    public HostedZoneConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        HostedZoneConfig.Builder hostedZoneConfig = HostedZoneConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Comment", targetDepth)) {
                    hostedZoneConfig.comment(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PrivateZone", targetDepth)) continue;
                hostedZoneConfig.privateZone(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (HostedZoneConfig)hostedZoneConfig.build();
    }

    public static HostedZoneConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

