/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TestDNSAnswerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, TestDNSAnswerRequest> {
    private final String hostedZoneId;
    private final String recordName;
    private final String recordType;
    private final String resolverIP;
    private final String edns0ClientSubnetIP;
    private final String edns0ClientSubnetMask;

    private TestDNSAnswerRequest(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.recordName = builder.recordName;
        this.recordType = builder.recordType;
        this.resolverIP = builder.resolverIP;
        this.edns0ClientSubnetIP = builder.edns0ClientSubnetIP;
        this.edns0ClientSubnetMask = builder.edns0ClientSubnetMask;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String recordName() {
        return this.recordName;
    }

    public String recordType() {
        return this.recordType;
    }

    public String resolverIP() {
        return this.resolverIP;
    }

    public String edns0ClientSubnetIP() {
        return this.edns0ClientSubnetIP;
    }

    public String edns0ClientSubnetMask() {
        return this.edns0ClientSubnetMask;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostedZoneId() == null ? 0 : this.hostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.recordName() == null ? 0 : this.recordName().hashCode());
        hashCode = 31 * hashCode + (this.recordType() == null ? 0 : this.recordType().hashCode());
        hashCode = 31 * hashCode + (this.resolverIP() == null ? 0 : this.resolverIP().hashCode());
        hashCode = 31 * hashCode + (this.edns0ClientSubnetIP() == null ? 0 : this.edns0ClientSubnetIP().hashCode());
        hashCode = 31 * hashCode + (this.edns0ClientSubnetMask() == null ? 0 : this.edns0ClientSubnetMask().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestDNSAnswerRequest)) {
            return false;
        }
        TestDNSAnswerRequest other = (TestDNSAnswerRequest)((Object)obj);
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.recordName() == null ^ this.recordName() == null) {
            return false;
        }
        if (other.recordName() != null && !other.recordName().equals(this.recordName())) {
            return false;
        }
        if (other.recordType() == null ^ this.recordType() == null) {
            return false;
        }
        if (other.recordType() != null && !other.recordType().equals(this.recordType())) {
            return false;
        }
        if (other.resolverIP() == null ^ this.resolverIP() == null) {
            return false;
        }
        if (other.resolverIP() != null && !other.resolverIP().equals(this.resolverIP())) {
            return false;
        }
        if (other.edns0ClientSubnetIP() == null ^ this.edns0ClientSubnetIP() == null) {
            return false;
        }
        if (other.edns0ClientSubnetIP() != null && !other.edns0ClientSubnetIP().equals(this.edns0ClientSubnetIP())) {
            return false;
        }
        if (other.edns0ClientSubnetMask() == null ^ this.edns0ClientSubnetMask() == null) {
            return false;
        }
        return other.edns0ClientSubnetMask() == null || other.edns0ClientSubnetMask().equals(this.edns0ClientSubnetMask());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (this.recordName() != null) {
            sb.append("RecordName: ").append(this.recordName()).append(",");
        }
        if (this.recordType() != null) {
            sb.append("RecordType: ").append(this.recordType()).append(",");
        }
        if (this.resolverIP() != null) {
            sb.append("ResolverIP: ").append(this.resolverIP()).append(",");
        }
        if (this.edns0ClientSubnetIP() != null) {
            sb.append("EDNS0ClientSubnetIP: ").append(this.edns0ClientSubnetIP()).append(",");
        }
        if (this.edns0ClientSubnetMask() != null) {
            sb.append("EDNS0ClientSubnetMask: ").append(this.edns0ClientSubnetMask()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String recordName;
        private String recordType;
        private String resolverIP;
        private String edns0ClientSubnetIP;
        private String edns0ClientSubnetMask;

        private BuilderImpl() {
        }

        private BuilderImpl(TestDNSAnswerRequest model) {
            this.setHostedZoneId(model.hostedZoneId);
            this.setRecordName(model.recordName);
            this.setRecordType(model.recordType);
            this.setResolverIP(model.resolverIP);
            this.setEDNS0ClientSubnetIP(model.edns0ClientSubnetIP);
            this.setEDNS0ClientSubnetMask(model.edns0ClientSubnetMask);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getRecordName() {
            return this.recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        public final String getRecordType() {
            return this.recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public final Builder recordType(RRType recordType) {
            this.recordType(recordType.toString());
            return this;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        public final String getResolverIP() {
            return this.resolverIP;
        }

        @Override
        public final Builder resolverIP(String resolverIP) {
            this.resolverIP = resolverIP;
            return this;
        }

        public final void setResolverIP(String resolverIP) {
            this.resolverIP = resolverIP;
        }

        public final String getEDNS0ClientSubnetIP() {
            return this.edns0ClientSubnetIP;
        }

        @Override
        public final Builder edns0ClientSubnetIP(String edns0ClientSubnetIP) {
            this.edns0ClientSubnetIP = edns0ClientSubnetIP;
            return this;
        }

        public final void setEDNS0ClientSubnetIP(String edns0ClientSubnetIP) {
            this.edns0ClientSubnetIP = edns0ClientSubnetIP;
        }

        public final String getEDNS0ClientSubnetMask() {
            return this.edns0ClientSubnetMask;
        }

        @Override
        public final Builder edns0ClientSubnetMask(String edns0ClientSubnetMask) {
            this.edns0ClientSubnetMask = edns0ClientSubnetMask;
            return this;
        }

        public final void setEDNS0ClientSubnetMask(String edns0ClientSubnetMask) {
            this.edns0ClientSubnetMask = edns0ClientSubnetMask;
        }

        public TestDNSAnswerRequest build() {
            return new TestDNSAnswerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TestDNSAnswerRequest> {
        public Builder hostedZoneId(String var1);

        public Builder recordName(String var1);

        public Builder recordType(String var1);

        public Builder recordType(RRType var1);

        public Builder resolverIP(String var1);

        public Builder edns0ClientSubnetIP(String var1);

        public Builder edns0ClientSubnetMask(String var1);
    }
}

