/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.TrafficPolicySummariesCopier;
import software.amazon.awssdk.services.route53.model.TrafficPolicySummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTrafficPoliciesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTrafficPoliciesResponse> {
    private final List<TrafficPolicySummary> trafficPolicySummaries;
    private final Boolean isTruncated;
    private final String trafficPolicyIdMarker;
    private final String maxItems;

    private ListTrafficPoliciesResponse(BuilderImpl builder) {
        this.trafficPolicySummaries = builder.trafficPolicySummaries;
        this.isTruncated = builder.isTruncated;
        this.trafficPolicyIdMarker = builder.trafficPolicyIdMarker;
        this.maxItems = builder.maxItems;
    }

    public List<TrafficPolicySummary> trafficPolicySummaries() {
        return this.trafficPolicySummaries;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String trafficPolicyIdMarker() {
        return this.trafficPolicyIdMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.trafficPolicySummaries() == null ? 0 : this.trafficPolicySummaries().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.trafficPolicyIdMarker() == null ? 0 : this.trafficPolicyIdMarker().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPoliciesResponse)) {
            return false;
        }
        ListTrafficPoliciesResponse other = (ListTrafficPoliciesResponse)((Object)obj);
        if (other.trafficPolicySummaries() == null ^ this.trafficPolicySummaries() == null) {
            return false;
        }
        if (other.trafficPolicySummaries() != null && !other.trafficPolicySummaries().equals(this.trafficPolicySummaries())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.trafficPolicyIdMarker() == null ^ this.trafficPolicyIdMarker() == null) {
            return false;
        }
        if (other.trafficPolicyIdMarker() != null && !other.trafficPolicyIdMarker().equals(this.trafficPolicyIdMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.trafficPolicySummaries() != null) {
            sb.append("TrafficPolicySummaries: ").append(this.trafficPolicySummaries()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.trafficPolicyIdMarker() != null) {
            sb.append("TrafficPolicyIdMarker: ").append(this.trafficPolicyIdMarker()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TrafficPolicySummary> trafficPolicySummaries;
        private Boolean isTruncated;
        private String trafficPolicyIdMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPoliciesResponse model) {
            this.setTrafficPolicySummaries(model.trafficPolicySummaries);
            this.setIsTruncated(model.isTruncated);
            this.setTrafficPolicyIdMarker(model.trafficPolicyIdMarker);
            this.setMaxItems(model.maxItems);
        }

        public final Collection<TrafficPolicySummary> getTrafficPolicySummaries() {
            return this.trafficPolicySummaries;
        }

        @Override
        public final Builder trafficPolicySummaries(Collection<TrafficPolicySummary> trafficPolicySummaries) {
            this.trafficPolicySummaries = TrafficPolicySummariesCopier.copy(trafficPolicySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicySummaries(TrafficPolicySummary ... trafficPolicySummaries) {
            this.trafficPolicySummaries(Arrays.asList(trafficPolicySummaries));
            return this;
        }

        public final void setTrafficPolicySummaries(Collection<TrafficPolicySummary> trafficPolicySummaries) {
            this.trafficPolicySummaries = TrafficPolicySummariesCopier.copy(trafficPolicySummaries);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getTrafficPolicyIdMarker() {
            return this.trafficPolicyIdMarker;
        }

        @Override
        public final Builder trafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
            return this;
        }

        public final void setTrafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListTrafficPoliciesResponse build() {
            return new ListTrafficPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTrafficPoliciesResponse> {
        public Builder trafficPolicySummaries(Collection<TrafficPolicySummary> var1);

        public Builder trafficPolicySummaries(TrafficPolicySummary ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder trafficPolicyIdMarker(String var1);

        public Builder maxItems(String var1);
    }
}

