/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHostedZonesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListHostedZonesRequest> {
    private final String marker;
    private final String maxItems;
    private final String delegationSetId;

    private ListHostedZonesRequest(BuilderImpl builder) {
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.delegationSetId = builder.delegationSetId;
    }

    public String marker() {
        return this.marker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public String delegationSetId() {
        return this.delegationSetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        hashCode = 31 * hashCode + (this.delegationSetId() == null ? 0 : this.delegationSetId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesRequest)) {
            return false;
        }
        ListHostedZonesRequest other = (ListHostedZonesRequest)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        if (other.delegationSetId() == null ^ this.delegationSetId() == null) {
            return false;
        }
        return other.delegationSetId() == null || other.delegationSetId().equals(this.delegationSetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (this.delegationSetId() != null) {
            sb.append("DelegationSetId: ").append(this.delegationSetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private String maxItems;
        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesRequest model) {
            this.setMarker(model.marker);
            this.setMaxItems(model.maxItems);
            this.setDelegationSetId(model.delegationSetId);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public final String getDelegationSetId() {
            return this.delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        public ListHostedZonesRequest build() {
            return new ListHostedZonesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListHostedZonesRequest> {
        public Builder marker(String var1);

        public Builder maxItems(String var1);

        public Builder delegationSetId(String var1);
    }
}

