/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.model.HealthChecksCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHealthChecksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListHealthChecksResponse> {
    private final List<HealthCheck> healthChecks;
    private final String marker;
    private final Boolean isTruncated;
    private final String nextMarker;
    private final String maxItems;

    private ListHealthChecksResponse(BuilderImpl builder) {
        this.healthChecks = builder.healthChecks;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    public List<HealthCheck> healthChecks() {
        return this.healthChecks;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.healthChecks() == null ? 0 : this.healthChecks().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthChecksResponse)) {
            return false;
        }
        ListHealthChecksResponse other = (ListHealthChecksResponse)((Object)obj);
        if (other.healthChecks() == null ^ this.healthChecks() == null) {
            return false;
        }
        if (other.healthChecks() != null && !other.healthChecks().equals(this.healthChecks())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.healthChecks() != null) {
            sb.append("HealthChecks: ").append(this.healthChecks()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<HealthCheck> healthChecks;
        private String marker;
        private Boolean isTruncated;
        private String nextMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHealthChecksResponse model) {
            this.setHealthChecks(model.healthChecks);
            this.setMarker(model.marker);
            this.setIsTruncated(model.isTruncated);
            this.setNextMarker(model.nextMarker);
            this.setMaxItems(model.maxItems);
        }

        public final Collection<HealthCheck> getHealthChecks() {
            return this.healthChecks;
        }

        @Override
        public final Builder healthChecks(Collection<HealthCheck> healthChecks) {
            this.healthChecks = HealthChecksCopier.copy(healthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthChecks(HealthCheck ... healthChecks) {
            this.healthChecks(Arrays.asList(healthChecks));
            return this;
        }

        public final void setHealthChecks(Collection<HealthCheck> healthChecks) {
            this.healthChecks = HealthChecksCopier.copy(healthChecks);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListHealthChecksResponse build() {
            return new ListHealthChecksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListHealthChecksResponse> {
        public Builder healthChecks(Collection<HealthCheck> var1);

        public Builder healthChecks(HealthCheck ... var1);

        public Builder marker(String var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextMarker(String var1);

        public Builder maxItems(String var1);
    }
}

