/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import software.amazon.awssdk.services.route53.model.HealthCheckRegion;
import software.amazon.awssdk.services.route53.model.StatusReport;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HealthCheckObservation
implements ToCopyableBuilder<Builder, HealthCheckObservation> {
    private final String region;
    private final String ipAddress;
    private final StatusReport statusReport;

    private HealthCheckObservation(BuilderImpl builder) {
        this.region = builder.region;
        this.ipAddress = builder.ipAddress;
        this.statusReport = builder.statusReport;
    }

    public String region() {
        return this.region;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public StatusReport statusReport() {
        return this.statusReport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.region() == null ? 0 : this.region().hashCode());
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.statusReport() == null ? 0 : this.statusReport().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckObservation)) {
            return false;
        }
        HealthCheckObservation other = (HealthCheckObservation)obj;
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.statusReport() == null ^ this.statusReport() == null) {
            return false;
        }
        return other.statusReport() == null || other.statusReport().equals(this.statusReport());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IPAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.statusReport() != null) {
            sb.append("StatusReport: ").append(this.statusReport()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String region;
        private String ipAddress;
        private StatusReport statusReport;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckObservation model) {
            this.setRegion(model.region);
            this.setIPAddress(model.ipAddress);
            this.setStatusReport(model.statusReport);
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(HealthCheckRegion region) {
            this.region(region.toString());
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getIPAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIPAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final StatusReport getStatusReport() {
            return this.statusReport;
        }

        @Override
        public final Builder statusReport(StatusReport statusReport) {
            this.statusReport = statusReport;
            return this;
        }

        public final void setStatusReport(StatusReport statusReport) {
            this.statusReport = statusReport;
        }

        public HealthCheckObservation build() {
            return new HealthCheckObservation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HealthCheckObservation> {
        public Builder region(String var1);

        public Builder region(HealthCheckRegion var1);

        public Builder ipAddress(String var1);

        public Builder statusReport(StatusReport var1);
    }
}

