/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListGeoLocationsRequestMarshaller
implements Marshaller<Request<ListGeoLocationsRequest>, ListGeoLocationsRequest> {
    public Request<ListGeoLocationsRequest> marshall(ListGeoLocationsRequest listGeoLocationsRequest) {
        if (listGeoLocationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listGeoLocationsRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/geolocations";
        request.setResourcePath(uriResourcePath);
        if (listGeoLocationsRequest.startContinentCode() != null) {
            request.addParameter("startcontinentcode", StringUtils.fromString((String)listGeoLocationsRequest.startContinentCode()));
        }
        if (listGeoLocationsRequest.startCountryCode() != null) {
            request.addParameter("startcountrycode", StringUtils.fromString((String)listGeoLocationsRequest.startCountryCode()));
        }
        if (listGeoLocationsRequest.startSubdivisionCode() != null) {
            request.addParameter("startsubdivisioncode", StringUtils.fromString((String)listGeoLocationsRequest.startSubdivisionCode()));
        }
        if (listGeoLocationsRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listGeoLocationsRequest.maxItems()));
        }
        return request;
    }
}

