/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.GeoLocation;

public class GeoLocationUnmarshaller
implements Unmarshaller<GeoLocation, StaxUnmarshallerContext> {
    private static final GeoLocationUnmarshaller INSTANCE = new GeoLocationUnmarshaller();

    public GeoLocation unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        GeoLocation.Builder geoLocation = GeoLocation.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ContinentCode", targetDepth)) {
                    geoLocation.continentCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CountryCode", targetDepth)) {
                    geoLocation.countryCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SubdivisionCode", targetDepth)) continue;
                geoLocation.subdivisionCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (GeoLocation)geoLocation.build();
    }

    public static GeoLocationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

