/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.OperationSummary;

@SdkInternalApi
public class OperationSummaryMarshaller {
    private static final MarshallingInfo<String> OPERATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperationId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<Instant> SUBMITTEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmittedDate").build();
    private static final OperationSummaryMarshaller instance = new OperationSummaryMarshaller();

    public static OperationSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(OperationSummary operationSummary, ProtocolMarshaller protocolMarshaller) {
        if (operationSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)operationSummary.operationId(), OPERATIONID_BINDING);
            protocolMarshaller.marshall((Object)operationSummary.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)operationSummary.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)operationSummary.submittedDate(), SUBMITTEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

