/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDomainContactRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateDomainContactRequest> {
    private final String domainName;
    private final ContactDetail adminContact;
    private final ContactDetail registrantContact;
    private final ContactDetail techContact;

    private UpdateDomainContactRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
    }

    public String domainName() {
        return this.domainName;
    }

    public ContactDetail adminContact() {
        return this.adminContact;
    }

    public ContactDetail registrantContact() {
        return this.registrantContact;
    }

    public ContactDetail techContact() {
        return this.techContact;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.adminContact() == null ? 0 : this.adminContact().hashCode());
        hashCode = 31 * hashCode + (this.registrantContact() == null ? 0 : this.registrantContact().hashCode());
        hashCode = 31 * hashCode + (this.techContact() == null ? 0 : this.techContact().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainContactRequest)) {
            return false;
        }
        UpdateDomainContactRequest other = (UpdateDomainContactRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.adminContact() == null ^ this.adminContact() == null) {
            return false;
        }
        if (other.adminContact() != null && !other.adminContact().equals(this.adminContact())) {
            return false;
        }
        if (other.registrantContact() == null ^ this.registrantContact() == null) {
            return false;
        }
        if (other.registrantContact() != null && !other.registrantContact().equals(this.registrantContact())) {
            return false;
        }
        if (other.techContact() == null ^ this.techContact() == null) {
            return false;
        }
        return other.techContact() == null || other.techContact().equals(this.techContact());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.adminContact() != null) {
            sb.append("AdminContact: ").append(this.adminContact()).append(",");
        }
        if (this.registrantContact() != null) {
            sb.append("RegistrantContact: ").append(this.registrantContact()).append(",");
        }
        if (this.techContact() != null) {
            sb.append("TechContact: ").append(this.techContact()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private ContactDetail adminContact;
        private ContactDetail registrantContact;
        private ContactDetail techContact;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainContactRequest model) {
            this.setDomainName(model.domainName);
            this.setAdminContact(model.adminContact);
            this.setRegistrantContact(model.registrantContact);
            this.setTechContact(model.techContact);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ContactDetail getAdminContact() {
            return this.adminContact;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
        }

        public final ContactDetail getRegistrantContact() {
            return this.registrantContact;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
        }

        public final ContactDetail getTechContact() {
            return this.techContact;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail techContact) {
            this.techContact = techContact;
        }

        public UpdateDomainContactRequest build() {
            return new UpdateDomainContactRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateDomainContactRequest> {
        public Builder domainName(String var1);

        public Builder adminContact(ContactDetail var1);

        public Builder registrantContact(ContactDetail var1);

        public Builder techContact(ContactDetail var1);
    }
}

