/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;
import software.amazon.awssdk.services.route53domains.model.DomainStatusListCopier;
import software.amazon.awssdk.services.route53domains.model.Nameserver;
import software.amazon.awssdk.services.route53domains.model.NameserverListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDomainDetailResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetDomainDetailResponse> {
    private final String domainName;
    private final List<Nameserver> nameservers;
    private final Boolean autoRenew;
    private final ContactDetail adminContact;
    private final ContactDetail registrantContact;
    private final ContactDetail techContact;
    private final Boolean adminPrivacy;
    private final Boolean registrantPrivacy;
    private final Boolean techPrivacy;
    private final String registrarName;
    private final String whoIsServer;
    private final String registrarUrl;
    private final String abuseContactEmail;
    private final String abuseContactPhone;
    private final String registryDomainId;
    private final Instant creationDate;
    private final Instant updatedDate;
    private final Instant expirationDate;
    private final String reseller;
    private final String dnsSec;
    private final List<String> statusList;

    private GetDomainDetailResponse(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.nameservers = builder.nameservers;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
        this.registrarName = builder.registrarName;
        this.whoIsServer = builder.whoIsServer;
        this.registrarUrl = builder.registrarUrl;
        this.abuseContactEmail = builder.abuseContactEmail;
        this.abuseContactPhone = builder.abuseContactPhone;
        this.registryDomainId = builder.registryDomainId;
        this.creationDate = builder.creationDate;
        this.updatedDate = builder.updatedDate;
        this.expirationDate = builder.expirationDate;
        this.reseller = builder.reseller;
        this.dnsSec = builder.dnsSec;
        this.statusList = builder.statusList;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<Nameserver> nameservers() {
        return this.nameservers;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public ContactDetail adminContact() {
        return this.adminContact;
    }

    public ContactDetail registrantContact() {
        return this.registrantContact;
    }

    public ContactDetail techContact() {
        return this.techContact;
    }

    public Boolean adminPrivacy() {
        return this.adminPrivacy;
    }

    public Boolean registrantPrivacy() {
        return this.registrantPrivacy;
    }

    public Boolean techPrivacy() {
        return this.techPrivacy;
    }

    public String registrarName() {
        return this.registrarName;
    }

    public String whoIsServer() {
        return this.whoIsServer;
    }

    public String registrarUrl() {
        return this.registrarUrl;
    }

    public String abuseContactEmail() {
        return this.abuseContactEmail;
    }

    public String abuseContactPhone() {
        return this.abuseContactPhone;
    }

    public String registryDomainId() {
        return this.registryDomainId;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant updatedDate() {
        return this.updatedDate;
    }

    public Instant expirationDate() {
        return this.expirationDate;
    }

    public String reseller() {
        return this.reseller;
    }

    public String dnsSec() {
        return this.dnsSec;
    }

    public List<String> statusList() {
        return this.statusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.nameservers() == null ? 0 : this.nameservers().hashCode());
        hashCode = 31 * hashCode + (this.autoRenew() == null ? 0 : this.autoRenew().hashCode());
        hashCode = 31 * hashCode + (this.adminContact() == null ? 0 : this.adminContact().hashCode());
        hashCode = 31 * hashCode + (this.registrantContact() == null ? 0 : this.registrantContact().hashCode());
        hashCode = 31 * hashCode + (this.techContact() == null ? 0 : this.techContact().hashCode());
        hashCode = 31 * hashCode + (this.adminPrivacy() == null ? 0 : this.adminPrivacy().hashCode());
        hashCode = 31 * hashCode + (this.registrantPrivacy() == null ? 0 : this.registrantPrivacy().hashCode());
        hashCode = 31 * hashCode + (this.techPrivacy() == null ? 0 : this.techPrivacy().hashCode());
        hashCode = 31 * hashCode + (this.registrarName() == null ? 0 : this.registrarName().hashCode());
        hashCode = 31 * hashCode + (this.whoIsServer() == null ? 0 : this.whoIsServer().hashCode());
        hashCode = 31 * hashCode + (this.registrarUrl() == null ? 0 : this.registrarUrl().hashCode());
        hashCode = 31 * hashCode + (this.abuseContactEmail() == null ? 0 : this.abuseContactEmail().hashCode());
        hashCode = 31 * hashCode + (this.abuseContactPhone() == null ? 0 : this.abuseContactPhone().hashCode());
        hashCode = 31 * hashCode + (this.registryDomainId() == null ? 0 : this.registryDomainId().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.updatedDate() == null ? 0 : this.updatedDate().hashCode());
        hashCode = 31 * hashCode + (this.expirationDate() == null ? 0 : this.expirationDate().hashCode());
        hashCode = 31 * hashCode + (this.reseller() == null ? 0 : this.reseller().hashCode());
        hashCode = 31 * hashCode + (this.dnsSec() == null ? 0 : this.dnsSec().hashCode());
        hashCode = 31 * hashCode + (this.statusList() == null ? 0 : this.statusList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainDetailResponse)) {
            return false;
        }
        GetDomainDetailResponse other = (GetDomainDetailResponse)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.nameservers() == null ^ this.nameservers() == null) {
            return false;
        }
        if (other.nameservers() != null && !other.nameservers().equals(this.nameservers())) {
            return false;
        }
        if (other.autoRenew() == null ^ this.autoRenew() == null) {
            return false;
        }
        if (other.autoRenew() != null && !other.autoRenew().equals(this.autoRenew())) {
            return false;
        }
        if (other.adminContact() == null ^ this.adminContact() == null) {
            return false;
        }
        if (other.adminContact() != null && !other.adminContact().equals(this.adminContact())) {
            return false;
        }
        if (other.registrantContact() == null ^ this.registrantContact() == null) {
            return false;
        }
        if (other.registrantContact() != null && !other.registrantContact().equals(this.registrantContact())) {
            return false;
        }
        if (other.techContact() == null ^ this.techContact() == null) {
            return false;
        }
        if (other.techContact() != null && !other.techContact().equals(this.techContact())) {
            return false;
        }
        if (other.adminPrivacy() == null ^ this.adminPrivacy() == null) {
            return false;
        }
        if (other.adminPrivacy() != null && !other.adminPrivacy().equals(this.adminPrivacy())) {
            return false;
        }
        if (other.registrantPrivacy() == null ^ this.registrantPrivacy() == null) {
            return false;
        }
        if (other.registrantPrivacy() != null && !other.registrantPrivacy().equals(this.registrantPrivacy())) {
            return false;
        }
        if (other.techPrivacy() == null ^ this.techPrivacy() == null) {
            return false;
        }
        if (other.techPrivacy() != null && !other.techPrivacy().equals(this.techPrivacy())) {
            return false;
        }
        if (other.registrarName() == null ^ this.registrarName() == null) {
            return false;
        }
        if (other.registrarName() != null && !other.registrarName().equals(this.registrarName())) {
            return false;
        }
        if (other.whoIsServer() == null ^ this.whoIsServer() == null) {
            return false;
        }
        if (other.whoIsServer() != null && !other.whoIsServer().equals(this.whoIsServer())) {
            return false;
        }
        if (other.registrarUrl() == null ^ this.registrarUrl() == null) {
            return false;
        }
        if (other.registrarUrl() != null && !other.registrarUrl().equals(this.registrarUrl())) {
            return false;
        }
        if (other.abuseContactEmail() == null ^ this.abuseContactEmail() == null) {
            return false;
        }
        if (other.abuseContactEmail() != null && !other.abuseContactEmail().equals(this.abuseContactEmail())) {
            return false;
        }
        if (other.abuseContactPhone() == null ^ this.abuseContactPhone() == null) {
            return false;
        }
        if (other.abuseContactPhone() != null && !other.abuseContactPhone().equals(this.abuseContactPhone())) {
            return false;
        }
        if (other.registryDomainId() == null ^ this.registryDomainId() == null) {
            return false;
        }
        if (other.registryDomainId() != null && !other.registryDomainId().equals(this.registryDomainId())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.updatedDate() == null ^ this.updatedDate() == null) {
            return false;
        }
        if (other.updatedDate() != null && !other.updatedDate().equals(this.updatedDate())) {
            return false;
        }
        if (other.expirationDate() == null ^ this.expirationDate() == null) {
            return false;
        }
        if (other.expirationDate() != null && !other.expirationDate().equals(this.expirationDate())) {
            return false;
        }
        if (other.reseller() == null ^ this.reseller() == null) {
            return false;
        }
        if (other.reseller() != null && !other.reseller().equals(this.reseller())) {
            return false;
        }
        if (other.dnsSec() == null ^ this.dnsSec() == null) {
            return false;
        }
        if (other.dnsSec() != null && !other.dnsSec().equals(this.dnsSec())) {
            return false;
        }
        if (other.statusList() == null ^ this.statusList() == null) {
            return false;
        }
        return other.statusList() == null || other.statusList().equals(this.statusList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.nameservers() != null) {
            sb.append("Nameservers: ").append(this.nameservers()).append(",");
        }
        if (this.autoRenew() != null) {
            sb.append("AutoRenew: ").append(this.autoRenew()).append(",");
        }
        if (this.adminContact() != null) {
            sb.append("AdminContact: ").append(this.adminContact()).append(",");
        }
        if (this.registrantContact() != null) {
            sb.append("RegistrantContact: ").append(this.registrantContact()).append(",");
        }
        if (this.techContact() != null) {
            sb.append("TechContact: ").append(this.techContact()).append(",");
        }
        if (this.adminPrivacy() != null) {
            sb.append("AdminPrivacy: ").append(this.adminPrivacy()).append(",");
        }
        if (this.registrantPrivacy() != null) {
            sb.append("RegistrantPrivacy: ").append(this.registrantPrivacy()).append(",");
        }
        if (this.techPrivacy() != null) {
            sb.append("TechPrivacy: ").append(this.techPrivacy()).append(",");
        }
        if (this.registrarName() != null) {
            sb.append("RegistrarName: ").append(this.registrarName()).append(",");
        }
        if (this.whoIsServer() != null) {
            sb.append("WhoIsServer: ").append(this.whoIsServer()).append(",");
        }
        if (this.registrarUrl() != null) {
            sb.append("RegistrarUrl: ").append(this.registrarUrl()).append(",");
        }
        if (this.abuseContactEmail() != null) {
            sb.append("AbuseContactEmail: ").append(this.abuseContactEmail()).append(",");
        }
        if (this.abuseContactPhone() != null) {
            sb.append("AbuseContactPhone: ").append(this.abuseContactPhone()).append(",");
        }
        if (this.registryDomainId() != null) {
            sb.append("RegistryDomainId: ").append(this.registryDomainId()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.updatedDate() != null) {
            sb.append("UpdatedDate: ").append(this.updatedDate()).append(",");
        }
        if (this.expirationDate() != null) {
            sb.append("ExpirationDate: ").append(this.expirationDate()).append(",");
        }
        if (this.reseller() != null) {
            sb.append("Reseller: ").append(this.reseller()).append(",");
        }
        if (this.dnsSec() != null) {
            sb.append("DnsSec: ").append(this.dnsSec()).append(",");
        }
        if (this.statusList() != null) {
            sb.append("StatusList: ").append(this.statusList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<Nameserver> nameservers;
        private Boolean autoRenew;
        private ContactDetail adminContact;
        private ContactDetail registrantContact;
        private ContactDetail techContact;
        private Boolean adminPrivacy;
        private Boolean registrantPrivacy;
        private Boolean techPrivacy;
        private String registrarName;
        private String whoIsServer;
        private String registrarUrl;
        private String abuseContactEmail;
        private String abuseContactPhone;
        private String registryDomainId;
        private Instant creationDate;
        private Instant updatedDate;
        private Instant expirationDate;
        private String reseller;
        private String dnsSec;
        private List<String> statusList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainDetailResponse model) {
            this.setDomainName(model.domainName);
            this.setNameservers(model.nameservers);
            this.setAutoRenew(model.autoRenew);
            this.setAdminContact(model.adminContact);
            this.setRegistrantContact(model.registrantContact);
            this.setTechContact(model.techContact);
            this.setAdminPrivacy(model.adminPrivacy);
            this.setRegistrantPrivacy(model.registrantPrivacy);
            this.setTechPrivacy(model.techPrivacy);
            this.setRegistrarName(model.registrarName);
            this.setWhoIsServer(model.whoIsServer);
            this.setRegistrarUrl(model.registrarUrl);
            this.setAbuseContactEmail(model.abuseContactEmail);
            this.setAbuseContactPhone(model.abuseContactPhone);
            this.setRegistryDomainId(model.registryDomainId);
            this.setCreationDate(model.creationDate);
            this.setUpdatedDate(model.updatedDate);
            this.setExpirationDate(model.expirationDate);
            this.setReseller(model.reseller);
            this.setDnsSec(model.dnsSec);
            this.setStatusList(model.statusList);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<Nameserver> getNameservers() {
            return this.nameservers;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver ... nameservers) {
            this.nameservers(Arrays.asList(nameservers));
            return this;
        }

        public final void setNameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
        }

        @SafeVarargs
        public final void setNameservers(Nameserver ... nameservers) {
            this.nameservers(Arrays.asList(nameservers));
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final ContactDetail getAdminContact() {
            return this.adminContact;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
        }

        public final ContactDetail getRegistrantContact() {
            return this.registrantContact;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
        }

        public final ContactDetail getTechContact() {
            return this.techContact;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail techContact) {
            this.techContact = techContact;
        }

        public final Boolean getAdminPrivacy() {
            return this.adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        public final Boolean getRegistrantPrivacy() {
            return this.registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        public final Boolean getTechPrivacy() {
            return this.techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        public final String getRegistrarName() {
            return this.registrarName;
        }

        @Override
        public final Builder registrarName(String registrarName) {
            this.registrarName = registrarName;
            return this;
        }

        public final void setRegistrarName(String registrarName) {
            this.registrarName = registrarName;
        }

        public final String getWhoIsServer() {
            return this.whoIsServer;
        }

        @Override
        public final Builder whoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
            return this;
        }

        public final void setWhoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
        }

        public final String getRegistrarUrl() {
            return this.registrarUrl;
        }

        @Override
        public final Builder registrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
            return this;
        }

        public final void setRegistrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
        }

        public final String getAbuseContactEmail() {
            return this.abuseContactEmail;
        }

        @Override
        public final Builder abuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
            return this;
        }

        public final void setAbuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
        }

        public final String getAbuseContactPhone() {
            return this.abuseContactPhone;
        }

        @Override
        public final Builder abuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
            return this;
        }

        public final void setAbuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
        }

        public final String getRegistryDomainId() {
            return this.registryDomainId;
        }

        @Override
        public final Builder registryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
            return this;
        }

        public final void setRegistryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getUpdatedDate() {
            return this.updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final String getReseller() {
            return this.reseller;
        }

        @Override
        public final Builder reseller(String reseller) {
            this.reseller = reseller;
            return this;
        }

        public final void setReseller(String reseller) {
            this.reseller = reseller;
        }

        public final String getDnsSec() {
            return this.dnsSec;
        }

        @Override
        public final Builder dnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
            return this;
        }

        public final void setDnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
        }

        public final Collection<String> getStatusList() {
            return this.statusList;
        }

        @Override
        public final Builder statusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(String ... statusList) {
            this.statusList(Arrays.asList(statusList));
            return this;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
        }

        @SafeVarargs
        public final void setStatusList(String ... statusList) {
            this.statusList(Arrays.asList(statusList));
        }

        public GetDomainDetailResponse build() {
            return new GetDomainDetailResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDomainDetailResponse> {
        public Builder domainName(String var1);

        public Builder nameservers(Collection<Nameserver> var1);

        public Builder nameservers(Nameserver ... var1);

        public Builder autoRenew(Boolean var1);

        public Builder adminContact(ContactDetail var1);

        public Builder registrantContact(ContactDetail var1);

        public Builder techContact(ContactDetail var1);

        public Builder adminPrivacy(Boolean var1);

        public Builder registrantPrivacy(Boolean var1);

        public Builder techPrivacy(Boolean var1);

        public Builder registrarName(String var1);

        public Builder whoIsServer(String var1);

        public Builder registrarUrl(String var1);

        public Builder abuseContactEmail(String var1);

        public Builder abuseContactPhone(String var1);

        public Builder registryDomainId(String var1);

        public Builder creationDate(Instant var1);

        public Builder updatedDate(Instant var1);

        public Builder expirationDate(Instant var1);

        public Builder reseller(String var1);

        public Builder dnsSec(String var1);

        public Builder statusList(Collection<String> var1);

        public Builder statusList(String ... var1);
    }
}

