/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53domains.model.TagKeyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteTagsForDomainRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteTagsForDomainRequest> {
    private final String domainName;
    private final List<String> tagsToDelete;

    private DeleteTagsForDomainRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.tagsToDelete = builder.tagsToDelete;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> tagsToDelete() {
        return this.tagsToDelete;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.tagsToDelete() == null ? 0 : this.tagsToDelete().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsForDomainRequest)) {
            return false;
        }
        DeleteTagsForDomainRequest other = (DeleteTagsForDomainRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.tagsToDelete() == null ^ this.tagsToDelete() == null) {
            return false;
        }
        return other.tagsToDelete() == null || other.tagsToDelete().equals(this.tagsToDelete());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.tagsToDelete() != null) {
            sb.append("TagsToDelete: ").append(this.tagsToDelete()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> tagsToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsForDomainRequest model) {
            this.setDomainName(model.domainName);
            this.setTagsToDelete(model.tagsToDelete);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getTagsToDelete() {
            return this.tagsToDelete;
        }

        @Override
        public final Builder tagsToDelete(Collection<String> tagsToDelete) {
            this.tagsToDelete = TagKeyListCopier.copy(tagsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToDelete(String ... tagsToDelete) {
            this.tagsToDelete(Arrays.asList(tagsToDelete));
            return this;
        }

        public final void setTagsToDelete(Collection<String> tagsToDelete) {
            this.tagsToDelete = TagKeyListCopier.copy(tagsToDelete);
        }

        @SafeVarargs
        public final void setTagsToDelete(String ... tagsToDelete) {
            this.tagsToDelete(Arrays.asList(tagsToDelete));
        }

        public DeleteTagsForDomainRequest build() {
            return new DeleteTagsForDomainRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteTagsForDomainRequest> {
        public Builder domainName(String var1);

        public Builder tagsToDelete(Collection<String> var1);

        public Builder tagsToDelete(String ... var1);
    }
}

