/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.DelegationSet;

public class DelegationSetUnmarshaller
implements Unmarshaller<DelegationSet, StaxUnmarshallerContext> {
    private static DelegationSetUnmarshaller INSTANCE;

    public DelegationSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        DelegationSet.Builder delegationSet;
        block7: {
            delegationSet = DelegationSet.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> nameServers = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    delegationSet.nameServers(nameServers);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Id", targetDepth)) {
                        delegationSet.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CallerReference", targetDepth)) {
                        delegationSet.callerReference(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NameServers", targetDepth)) {
                        nameServers = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("NameServers/NameServer", targetDepth)) continue;
                    nameServers.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            delegationSet.nameServers(nameServers);
        }
        return (DelegationSet)delegationSet.build();
    }

    public static DelegationSetUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DelegationSetUnmarshaller();
        }
        return INSTANCE;
    }
}

