/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.AlarmIdentifier;

public class AlarmIdentifierUnmarshaller
implements Unmarshaller<AlarmIdentifier, StaxUnmarshallerContext> {
    private static AlarmIdentifierUnmarshaller INSTANCE;

    public AlarmIdentifier unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AlarmIdentifier.Builder alarmIdentifier = AlarmIdentifier.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Region", targetDepth)) {
                    alarmIdentifier.region(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Name", targetDepth)) continue;
                alarmIdentifier.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AlarmIdentifier)alarmIdentifier.build();
    }

    public static AlarmIdentifierUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AlarmIdentifierUnmarshaller();
        }
        return INSTANCE;
    }
}

