/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInstance;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInstancesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTrafficPolicyInstancesByPolicyResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTrafficPolicyInstancesByPolicyResponse> {
    private final List<TrafficPolicyInstance> trafficPolicyInstances;
    private final String hostedZoneIdMarker;
    private final String trafficPolicyInstanceNameMarker;
    private final String trafficPolicyInstanceTypeMarker;
    private final Boolean isTruncated;
    private final String maxItems;

    private ListTrafficPolicyInstancesByPolicyResponse(BuilderImpl builder) {
        this.trafficPolicyInstances = builder.trafficPolicyInstances;
        this.hostedZoneIdMarker = builder.hostedZoneIdMarker;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.isTruncated = builder.isTruncated;
        this.maxItems = builder.maxItems;
    }

    public List<TrafficPolicyInstance> trafficPolicyInstances() {
        return this.trafficPolicyInstances;
    }

    public String hostedZoneIdMarker() {
        return this.hostedZoneIdMarker;
    }

    public String trafficPolicyInstanceNameMarker() {
        return this.trafficPolicyInstanceNameMarker;
    }

    public String trafficPolicyInstanceTypeMarker() {
        return this.trafficPolicyInstanceTypeMarker;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.trafficPolicyInstances() == null ? 0 : this.trafficPolicyInstances().hashCode());
        hashCode = 31 * hashCode + (this.hostedZoneIdMarker() == null ? 0 : this.hostedZoneIdMarker().hashCode());
        hashCode = 31 * hashCode + (this.trafficPolicyInstanceNameMarker() == null ? 0 : this.trafficPolicyInstanceNameMarker().hashCode());
        hashCode = 31 * hashCode + (this.trafficPolicyInstanceTypeMarker() == null ? 0 : this.trafficPolicyInstanceTypeMarker().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesByPolicyResponse)) {
            return false;
        }
        ListTrafficPolicyInstancesByPolicyResponse other = (ListTrafficPolicyInstancesByPolicyResponse)((Object)obj);
        if (other.trafficPolicyInstances() == null ^ this.trafficPolicyInstances() == null) {
            return false;
        }
        if (other.trafficPolicyInstances() != null && !other.trafficPolicyInstances().equals(this.trafficPolicyInstances())) {
            return false;
        }
        if (other.hostedZoneIdMarker() == null ^ this.hostedZoneIdMarker() == null) {
            return false;
        }
        if (other.hostedZoneIdMarker() != null && !other.hostedZoneIdMarker().equals(this.hostedZoneIdMarker())) {
            return false;
        }
        if (other.trafficPolicyInstanceNameMarker() == null ^ this.trafficPolicyInstanceNameMarker() == null) {
            return false;
        }
        if (other.trafficPolicyInstanceNameMarker() != null && !other.trafficPolicyInstanceNameMarker().equals(this.trafficPolicyInstanceNameMarker())) {
            return false;
        }
        if (other.trafficPolicyInstanceTypeMarker() == null ^ this.trafficPolicyInstanceTypeMarker() == null) {
            return false;
        }
        if (other.trafficPolicyInstanceTypeMarker() != null && !other.trafficPolicyInstanceTypeMarker().equals(this.trafficPolicyInstanceTypeMarker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.trafficPolicyInstances() != null) {
            sb.append("TrafficPolicyInstances: ").append(this.trafficPolicyInstances()).append(",");
        }
        if (this.hostedZoneIdMarker() != null) {
            sb.append("HostedZoneIdMarker: ").append(this.hostedZoneIdMarker()).append(",");
        }
        if (this.trafficPolicyInstanceNameMarker() != null) {
            sb.append("TrafficPolicyInstanceNameMarker: ").append(this.trafficPolicyInstanceNameMarker()).append(",");
        }
        if (this.trafficPolicyInstanceTypeMarker() != null) {
            sb.append("TrafficPolicyInstanceTypeMarker: ").append(this.trafficPolicyInstanceTypeMarker()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TrafficPolicyInstance> trafficPolicyInstances;
        private String hostedZoneIdMarker;
        private String trafficPolicyInstanceNameMarker;
        private String trafficPolicyInstanceTypeMarker;
        private Boolean isTruncated;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesByPolicyResponse model) {
            this.setTrafficPolicyInstances(model.trafficPolicyInstances);
            this.setHostedZoneIdMarker(model.hostedZoneIdMarker);
            this.setTrafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            this.setTrafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            this.setIsTruncated(model.isTruncated);
            this.setMaxItems(model.maxItems);
        }

        public final Collection<TrafficPolicyInstance> getTrafficPolicyInstances() {
            return this.trafficPolicyInstances;
        }

        @Override
        public final Builder trafficPolicyInstances(Collection<TrafficPolicyInstance> trafficPolicyInstances) {
            this.trafficPolicyInstances = TrafficPolicyInstancesCopier.copy(trafficPolicyInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicyInstances(TrafficPolicyInstance ... trafficPolicyInstances) {
            this.trafficPolicyInstances(Arrays.asList(trafficPolicyInstances));
            return this;
        }

        public final void setTrafficPolicyInstances(Collection<TrafficPolicyInstance> trafficPolicyInstances) {
            this.trafficPolicyInstances = TrafficPolicyInstancesCopier.copy(trafficPolicyInstances);
        }

        @SafeVarargs
        public final void setTrafficPolicyInstances(TrafficPolicyInstance ... trafficPolicyInstances) {
            this.trafficPolicyInstances(Arrays.asList(trafficPolicyInstances));
        }

        public final String getHostedZoneIdMarker() {
            return this.hostedZoneIdMarker;
        }

        @Override
        public final Builder hostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
            return this;
        }

        public final void setHostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return this.trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        public final String getTrafficPolicyInstanceTypeMarker() {
            return this.trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker.toString());
            return this;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        public final void setTrafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker.toString());
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListTrafficPolicyInstancesByPolicyResponse build() {
            return new ListTrafficPolicyInstancesByPolicyResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTrafficPolicyInstancesByPolicyResponse> {
        public Builder trafficPolicyInstances(Collection<TrafficPolicyInstance> var1);

        public Builder trafficPolicyInstances(TrafficPolicyInstance ... var1);

        public Builder hostedZoneIdMarker(String var1);

        public Builder trafficPolicyInstanceNameMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(RRType var1);

        public Builder isTruncated(Boolean var1);

        public Builder maxItems(String var1);
    }
}

