/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.HostedZonesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHostedZonesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListHostedZonesResponse> {
    private final List<HostedZone> hostedZones;
    private final String marker;
    private final Boolean isTruncated;
    private final String nextMarker;
    private final String maxItems;

    private ListHostedZonesResponse(BuilderImpl builder) {
        this.hostedZones = builder.hostedZones;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    public List<HostedZone> hostedZones() {
        return this.hostedZones;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostedZones() == null ? 0 : this.hostedZones().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesResponse)) {
            return false;
        }
        ListHostedZonesResponse other = (ListHostedZonesResponse)((Object)obj);
        if (other.hostedZones() == null ^ this.hostedZones() == null) {
            return false;
        }
        if (other.hostedZones() != null && !other.hostedZones().equals(this.hostedZones())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostedZones() != null) {
            sb.append("HostedZones: ").append(this.hostedZones()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<HostedZone> hostedZones;
        private String marker;
        private Boolean isTruncated;
        private String nextMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesResponse model) {
            this.setHostedZones(model.hostedZones);
            this.setMarker(model.marker);
            this.setIsTruncated(model.isTruncated);
            this.setNextMarker(model.nextMarker);
            this.setMaxItems(model.maxItems);
        }

        public final Collection<HostedZone> getHostedZones() {
            return this.hostedZones;
        }

        @Override
        public final Builder hostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(HostedZone ... hostedZones) {
            this.hostedZones(Arrays.asList(hostedZones));
            return this;
        }

        public final void setHostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
        }

        @SafeVarargs
        public final void setHostedZones(HostedZone ... hostedZones) {
            this.hostedZones(Arrays.asList(hostedZones));
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListHostedZonesResponse build() {
            return new ListHostedZonesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListHostedZonesResponse> {
        public Builder hostedZones(Collection<HostedZone> var1);

        public Builder hostedZones(HostedZone ... var1);

        public Builder marker(String var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextMarker(String var1);

        public Builder maxItems(String var1);
    }
}

