/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import software.amazon.awssdk.services.route53.model.CloudWatchRegion;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AlarmIdentifier
implements ToCopyableBuilder<Builder, AlarmIdentifier> {
    private final String region;
    private final String name;

    private AlarmIdentifier(BuilderImpl builder) {
        this.region = builder.region;
        this.name = builder.name;
    }

    public String region() {
        return this.region;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.region() == null ? 0 : this.region().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmIdentifier)) {
            return false;
        }
        AlarmIdentifier other = (AlarmIdentifier)obj;
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        return other.name() == null || other.name().equals(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String region;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmIdentifier model) {
            this.setRegion(model.region);
            this.setName(model.name);
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(CloudWatchRegion region) {
            this.region(region.toString());
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final void setRegion(CloudWatchRegion region) {
            this.region(region.toString());
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public AlarmIdentifier build() {
            return new AlarmIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AlarmIdentifier> {
        public Builder region(String var1);

        public Builder region(CloudWatchRegion var1);

        public Builder name(String var1);
    }
}

