/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.route53.model.AliasTarget;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.model.ChangeBatch;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.GeoLocation;
import software.amazon.awssdk.services.route53.model.ResourceRecord;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.utils.StringInputStream;

public class ChangeResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ChangeResourceRecordSetsRequest>, ChangeResourceRecordSetsRequest> {
    public Request<ChangeResourceRecordSetsRequest> marshall(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        if (changeResourceRecordSetsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)changeResourceRecordSetsRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/rrset/";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Id", changeResourceRecordSetsRequest.hostedZoneId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("ChangeResourceRecordSetsRequest");
            ChangeBatch changeBatch = changeResourceRecordSetsRequest.changeBatch();
            if (changeBatch != null) {
                List<Change> changeBatchChangesList;
                xmlWriter.startElement("ChangeBatch");
                if (changeBatch.comment() != null) {
                    xmlWriter.startElement("Comment").value(changeBatch.comment()).endElement();
                }
                if (!(changeBatchChangesList = changeBatch.changes()).isEmpty() || !(changeBatchChangesList instanceof SdkAutoConstructList)) {
                    xmlWriter.startElement("Changes");
                    for (Change changeBatchChangesListValue : changeBatchChangesList) {
                        ResourceRecordSet resourceRecordSet;
                        xmlWriter.startElement("Change");
                        if (changeBatchChangesListValue.actionAsString() != null) {
                            xmlWriter.startElement("Action").value(changeBatchChangesListValue.actionAsString()).endElement();
                        }
                        if ((resourceRecordSet = changeBatchChangesListValue.resourceRecordSet()) != null) {
                            AliasTarget aliasTarget;
                            List<ResourceRecord> resourceRecordSetResourceRecordsList;
                            GeoLocation geoLocation;
                            xmlWriter.startElement("ResourceRecordSet");
                            if (resourceRecordSet.name() != null) {
                                xmlWriter.startElement("Name").value(resourceRecordSet.name()).endElement();
                            }
                            if (resourceRecordSet.typeAsString() != null) {
                                xmlWriter.startElement("Type").value(resourceRecordSet.typeAsString()).endElement();
                            }
                            if (resourceRecordSet.setIdentifier() != null) {
                                xmlWriter.startElement("SetIdentifier").value(resourceRecordSet.setIdentifier()).endElement();
                            }
                            if (resourceRecordSet.weight() != null) {
                                xmlWriter.startElement("Weight").value((Object)resourceRecordSet.weight()).endElement();
                            }
                            if (resourceRecordSet.regionAsString() != null) {
                                xmlWriter.startElement("Region").value(resourceRecordSet.regionAsString()).endElement();
                            }
                            if ((geoLocation = resourceRecordSet.geoLocation()) != null) {
                                xmlWriter.startElement("GeoLocation");
                                if (geoLocation.continentCode() != null) {
                                    xmlWriter.startElement("ContinentCode").value(geoLocation.continentCode()).endElement();
                                }
                                if (geoLocation.countryCode() != null) {
                                    xmlWriter.startElement("CountryCode").value(geoLocation.countryCode()).endElement();
                                }
                                if (geoLocation.subdivisionCode() != null) {
                                    xmlWriter.startElement("SubdivisionCode").value(geoLocation.subdivisionCode()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (resourceRecordSet.failoverAsString() != null) {
                                xmlWriter.startElement("Failover").value(resourceRecordSet.failoverAsString()).endElement();
                            }
                            if (resourceRecordSet.multiValueAnswer() != null) {
                                xmlWriter.startElement("MultiValueAnswer").value((Object)resourceRecordSet.multiValueAnswer()).endElement();
                            }
                            if (resourceRecordSet.ttl() != null) {
                                xmlWriter.startElement("TTL").value((Object)resourceRecordSet.ttl()).endElement();
                            }
                            if (!(resourceRecordSetResourceRecordsList = resourceRecordSet.resourceRecords()).isEmpty() || !(resourceRecordSetResourceRecordsList instanceof SdkAutoConstructList)) {
                                xmlWriter.startElement("ResourceRecords");
                                for (ResourceRecord resourceRecordSetResourceRecordsListValue : resourceRecordSetResourceRecordsList) {
                                    xmlWriter.startElement("ResourceRecord");
                                    if (resourceRecordSetResourceRecordsListValue.value() != null) {
                                        xmlWriter.startElement("Value").value(resourceRecordSetResourceRecordsListValue.value()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((aliasTarget = resourceRecordSet.aliasTarget()) != null) {
                                xmlWriter.startElement("AliasTarget");
                                if (aliasTarget.hostedZoneId() != null) {
                                    xmlWriter.startElement("HostedZoneId").value(aliasTarget.hostedZoneId()).endElement();
                                }
                                if (aliasTarget.dnsName() != null) {
                                    xmlWriter.startElement("DNSName").value(aliasTarget.dnsName()).endElement();
                                }
                                if (aliasTarget.evaluateTargetHealth() != null) {
                                    xmlWriter.startElement("EvaluateTargetHealth").value((Object)aliasTarget.evaluateTargetHealth()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (resourceRecordSet.healthCheckId() != null) {
                                xmlWriter.startElement("HealthCheckId").value(resourceRecordSet.healthCheckId()).endElement();
                            }
                            if (resourceRecordSet.trafficPolicyInstanceId() != null) {
                                xmlWriter.startElement("TrafficPolicyInstanceId").value(resourceRecordSet.trafficPolicyInstanceId()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

