/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.TrafficPolicySummariesCopier;
import software.amazon.awssdk.services.route53.model.TrafficPolicySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrafficPoliciesResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListTrafficPoliciesResponse> {
    private final List<TrafficPolicySummary> trafficPolicySummaries;
    private final Boolean isTruncated;
    private final String trafficPolicyIdMarker;
    private final String maxItems;

    private ListTrafficPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicySummaries = builder.trafficPolicySummaries;
        this.isTruncated = builder.isTruncated;
        this.trafficPolicyIdMarker = builder.trafficPolicyIdMarker;
        this.maxItems = builder.maxItems;
    }

    public List<TrafficPolicySummary> trafficPolicySummaries() {
        return this.trafficPolicySummaries;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String trafficPolicyIdMarker() {
        return this.trafficPolicyIdMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicySummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPoliciesResponse)) {
            return false;
        }
        ListTrafficPoliciesResponse other = (ListTrafficPoliciesResponse)((Object)obj);
        return Objects.equals(this.trafficPolicySummaries(), other.trafficPolicySummaries()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.trafficPolicyIdMarker(), other.trafficPolicyIdMarker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListTrafficPoliciesResponse").add("TrafficPolicySummaries", this.trafficPolicySummaries()).add("IsTruncated", (Object)this.isTruncated()).add("TrafficPolicyIdMarker", (Object)this.trafficPolicyIdMarker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicySummaries": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicySummaries()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "TrafficPolicyIdMarker": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyIdMarker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<TrafficPolicySummary> trafficPolicySummaries = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String trafficPolicyIdMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPoliciesResponse model) {
            super(model);
            this.trafficPolicySummaries(model.trafficPolicySummaries);
            this.isTruncated(model.isTruncated);
            this.trafficPolicyIdMarker(model.trafficPolicyIdMarker);
            this.maxItems(model.maxItems);
        }

        public final Collection<TrafficPolicySummary.Builder> getTrafficPolicySummaries() {
            return this.trafficPolicySummaries != null ? (Collection)this.trafficPolicySummaries.stream().map(TrafficPolicySummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trafficPolicySummaries(Collection<TrafficPolicySummary> trafficPolicySummaries) {
            this.trafficPolicySummaries = TrafficPolicySummariesCopier.copy(trafficPolicySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicySummaries(TrafficPolicySummary ... trafficPolicySummaries) {
            this.trafficPolicySummaries(Arrays.asList(trafficPolicySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicySummaries(Consumer<TrafficPolicySummary.Builder> ... trafficPolicySummaries) {
            this.trafficPolicySummaries(Stream.of(trafficPolicySummaries).map(c -> (TrafficPolicySummary)((TrafficPolicySummary.Builder)TrafficPolicySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrafficPolicySummaries(Collection<TrafficPolicySummary.BuilderImpl> trafficPolicySummaries) {
            this.trafficPolicySummaries = TrafficPolicySummariesCopier.copyFromBuilder(trafficPolicySummaries);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getTrafficPolicyIdMarker() {
            return this.trafficPolicyIdMarker;
        }

        @Override
        public final Builder trafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
            return this;
        }

        public final void setTrafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListTrafficPoliciesResponse build() {
            return new ListTrafficPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, ListTrafficPoliciesResponse> {
        public Builder trafficPolicySummaries(Collection<TrafficPolicySummary> var1);

        public Builder trafficPolicySummaries(TrafficPolicySummary ... var1);

        public Builder trafficPolicySummaries(Consumer<TrafficPolicySummary.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder trafficPolicyIdMarker(String var1);

        public Builder maxItems(String var1);
    }
}

