/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest;

public class ListGeoLocationsRequestMarshaller
implements Marshaller<Request<ListGeoLocationsRequest>, ListGeoLocationsRequest> {
    public Request<ListGeoLocationsRequest> marshall(ListGeoLocationsRequest listGeoLocationsRequest) {
        if (listGeoLocationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listGeoLocationsRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/geolocations";
        request.setResourcePath(uriResourcePath);
        if (listGeoLocationsRequest.startContinentCode() != null) {
            request.addParameter("startcontinentcode", StringConversion.fromString((String)listGeoLocationsRequest.startContinentCode()));
        }
        if (listGeoLocationsRequest.startCountryCode() != null) {
            request.addParameter("startcountrycode", StringConversion.fromString((String)listGeoLocationsRequest.startCountryCode()));
        }
        if (listGeoLocationsRequest.startSubdivisionCode() != null) {
            request.addParameter("startsubdivisioncode", StringConversion.fromString((String)listGeoLocationsRequest.startSubdivisionCode()));
        }
        if (listGeoLocationsRequest.maxItems() != null) {
            request.addParameter("maxitems", StringConversion.fromString((String)listGeoLocationsRequest.maxItems()));
        }
        return request;
    }
}

