/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest;
import software.amazon.awssdk.utils.StringInputStream;

public class CreateTrafficPolicyRequestMarshaller
implements Marshaller<Request<CreateTrafficPolicyRequest>, CreateTrafficPolicyRequest> {
    public Request<CreateTrafficPolicyRequest> marshall(CreateTrafficPolicyRequest createTrafficPolicyRequest) {
        if (createTrafficPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createTrafficPolicyRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/trafficpolicy";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("CreateTrafficPolicyRequest");
            if (createTrafficPolicyRequest.name() != null) {
                xmlWriter.startElement("Name").value(createTrafficPolicyRequest.name()).endElement();
            }
            if (createTrafficPolicyRequest.document() != null) {
                xmlWriter.startElement("Document").value(createTrafficPolicyRequest.document()).endElement();
            }
            if (createTrafficPolicyRequest.comment() != null) {
                xmlWriter.startElement("Comment").value(createTrafficPolicyRequest.comment()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

