/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReusableDelegationSetRequest
extends Route53Request
implements ToCopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
    private final String callerReference;
    private final String hostedZoneId;

    private CreateReusableDelegationSetRequest(BuilderImpl builder) {
        super(builder);
        this.callerReference = builder.callerReference;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReusableDelegationSetRequest)) {
            return false;
        }
        CreateReusableDelegationSetRequest other = (CreateReusableDelegationSetRequest)((Object)obj);
        return Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId());
    }

    public String toString() {
        return ToString.builder((String)"CreateReusableDelegationSetRequest").add("CallerReference", (Object)this.callerReference()).add("HostedZoneId", (Object)this.hostedZoneId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String callerReference;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReusableDelegationSetRequest model) {
            super(model);
            this.callerReference(model.callerReference);
            this.hostedZoneId(model.hostedZoneId);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReusableDelegationSetRequest build() {
            return new CreateReusableDelegationSetRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
        public Builder callerReference(String var1);

        public Builder hostedZoneId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

