/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQueryLoggingConfigRequest
extends Route53Request
implements ToCopyableBuilder<Builder, CreateQueryLoggingConfigRequest> {
    private final String hostedZoneId;
    private final String cloudWatchLogsLogGroupArn;

    private CreateQueryLoggingConfigRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String cloudWatchLogsLogGroupArn() {
        return this.cloudWatchLogsLogGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsLogGroupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueryLoggingConfigRequest)) {
            return false;
        }
        CreateQueryLoggingConfigRequest other = (CreateQueryLoggingConfigRequest)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateQueryLoggingConfigRequest").add("HostedZoneId", (Object)this.hostedZoneId()).add("CloudWatchLogsLogGroupArn", (Object)this.cloudWatchLogsLogGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "CloudWatchLogsLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsLogGroupArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String cloudWatchLogsLogGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueryLoggingConfigRequest model) {
            super(model);
            this.hostedZoneId(model.hostedZoneId);
            this.cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return this.cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQueryLoggingConfigRequest build() {
            return new CreateQueryLoggingConfigRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, CreateQueryLoggingConfigRequest> {
        public Builder hostedZoneId(String var1);

        public Builder cloudWatchLogsLogGroupArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

