/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.route53.model.ChangeStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeInfo
implements ToCopyableBuilder<Builder, ChangeInfo> {
    private final String id;
    private final String status;
    private final Instant submittedAt;
    private final String comment;

    private ChangeInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.submittedAt = builder.submittedAt;
        this.comment = builder.comment;
    }

    public String id() {
        return this.id;
    }

    public ChangeStatus status() {
        return ChangeStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant submittedAt() {
        return this.submittedAt;
    }

    public String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeInfo)) {
            return false;
        }
        ChangeInfo other = (ChangeInfo)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.submittedAt(), other.submittedAt()) && Objects.equals(this.comment(), other.comment());
    }

    public String toString() {
        return ToString.builder((String)"ChangeInfo").add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("SubmittedAt", (Object)this.submittedAt()).add("Comment", (Object)this.comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SubmittedAt": {
                return Optional.ofNullable(clazz.cast(this.submittedAt()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String status;
        private Instant submittedAt;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeInfo model) {
            this.id(model.id);
            this.status(model.status);
            this.submittedAt(model.submittedAt);
            this.comment(model.comment);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getSubmittedAt() {
            return this.submittedAt;
        }

        @Override
        public final Builder submittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        public final void setSubmittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public ChangeInfo build() {
            return new ChangeInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChangeInfo> {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ChangeStatus var1);

        public Builder submittedAt(Instant var1);

        public Builder comment(String var1);
    }
}

