/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RegisterDomainRequestModelMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").isBinary(false).build();
    private static final MarshallingInfo<String> IDNLANGCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdnLangCode").isBinary(false).build();
    private static final MarshallingInfo<Integer> DURATIONINYEARS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationInYears").isBinary(false).build();
    private static final MarshallingInfo<Boolean> AUTORENEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoRenew").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ADMINCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdminContact").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REGISTRANTCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrantContact").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TECHCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TechContact").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PRIVACYPROTECTADMINCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivacyProtectAdminContact").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PRIVACYPROTECTREGISTRANTCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivacyProtectRegistrantContact").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PRIVACYPROTECTTECHCONTACT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivacyProtectTechContact").isBinary(false).build();
    private static final RegisterDomainRequestModelMarshaller INSTANCE = new RegisterDomainRequestModelMarshaller();

    private RegisterDomainRequestModelMarshaller() {
    }

    public static RegisterDomainRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RegisterDomainRequest registerDomainRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)registerDomainRequest), (String)"registerDomainRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)registerDomainRequest.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)registerDomainRequest.idnLangCode(), IDNLANGCODE_BINDING);
            protocolMarshaller.marshall((Object)registerDomainRequest.durationInYears(), DURATIONINYEARS_BINDING);
            protocolMarshaller.marshall((Object)registerDomainRequest.autoRenew(), AUTORENEW_BINDING);
            protocolMarshaller.marshall((Object)registerDomainRequest.adminContact(), ADMINCONTACT_BINDING);
            protocolMarshaller.marshall((Object)registerDomainRequest.registrantContact(), REGISTRANTCONTACT_BINDING);
            protocolMarshaller.marshall((Object)registerDomainRequest.techContact(), TECHCONTACT_BINDING);
            protocolMarshaller.marshall((Object)registerDomainRequest.privacyProtectAdminContact(), PRIVACYPROTECTADMINCONTACT_BINDING);
            protocolMarshaller.marshall((Object)registerDomainRequest.privacyProtectRegistrantContact(), PRIVACYPROTECTREGISTRANTCONTACT_BINDING);
            protocolMarshaller.marshall((Object)registerDomainRequest.privacyProtectTechContact(), PRIVACYPROTECTTECHCONTACT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

