/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CheckDomainAvailabilityRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, CheckDomainAvailabilityRequest> {
    private final String domainName;
    private final String idnLangCode;

    private CheckDomainAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.idnLangCode = builder.idnLangCode;
    }

    public String domainName() {
        return this.domainName;
    }

    public String idnLangCode() {
        return this.idnLangCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.idnLangCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainAvailabilityRequest)) {
            return false;
        }
        CheckDomainAvailabilityRequest other = (CheckDomainAvailabilityRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.idnLangCode(), other.idnLangCode());
    }

    public String toString() {
        return ToString.builder((String)"CheckDomainAvailabilityRequest").add("DomainName", (Object)this.domainName()).add("IdnLangCode", (Object)this.idnLangCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "IdnLangCode": {
                return Optional.of(clazz.cast(this.idnLangCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String idnLangCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainAvailabilityRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.idnLangCode(model.idnLangCode);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getIdnLangCode() {
            return this.idnLangCode;
        }

        @Override
        public final Builder idnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
            return this;
        }

        public final void setIdnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CheckDomainAvailabilityRequest build() {
            return new CheckDomainAvailabilityRequest(this);
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    CopyableBuilder<Builder, CheckDomainAvailabilityRequest> {
        public Builder domainName(String var1);

        public Builder idnLangCode(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

