/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.model.OperationType;
import software.amazon.awssdk.services.route53domains.transform.BillingRecordMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BillingRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, BillingRecord> {
    private final String domainName;
    private final String operation;
    private final String invoiceId;
    private final Instant billDate;
    private final Double price;

    private BillingRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.operation = builder.operation;
        this.invoiceId = builder.invoiceId;
        this.billDate = builder.billDate;
        this.price = builder.price;
    }

    public String domainName() {
        return this.domainName;
    }

    public OperationType operation() {
        return OperationType.fromValue(this.operation);
    }

    public String operationAsString() {
        return this.operation;
    }

    public String invoiceId() {
        return this.invoiceId;
    }

    public Instant billDate() {
        return this.billDate;
    }

    public Double price() {
        return this.price;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invoiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingRecord)) {
            return false;
        }
        BillingRecord other = (BillingRecord)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.invoiceId(), other.invoiceId()) && Objects.equals(this.billDate(), other.billDate()) && Objects.equals(this.price(), other.price());
    }

    public String toString() {
        return ToString.builder((String)"BillingRecord").add("DomainName", (Object)this.domainName()).add("Operation", (Object)this.operationAsString()).add("InvoiceId", (Object)this.invoiceId()).add("BillDate", (Object)this.billDate()).add("Price", (Object)this.price()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "Operation": {
                return Optional.of(clazz.cast(this.operationAsString()));
            }
            case "InvoiceId": {
                return Optional.of(clazz.cast(this.invoiceId()));
            }
            case "BillDate": {
                return Optional.of(clazz.cast(this.billDate()));
            }
            case "Price": {
                return Optional.of(clazz.cast(this.price()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BillingRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String operation;
        private String invoiceId;
        private Instant billDate;
        private Double price;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingRecord model) {
            this.domainName(model.domainName);
            this.operation(model.operation);
            this.invoiceId(model.invoiceId);
            this.billDate(model.billDate);
            this.price(model.price);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(OperationType operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final String getInvoiceId() {
            return this.invoiceId;
        }

        @Override
        public final Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public final void setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public final Instant getBillDate() {
            return this.billDate;
        }

        @Override
        public final Builder billDate(Instant billDate) {
            this.billDate = billDate;
            return this;
        }

        public final void setBillDate(Instant billDate) {
            this.billDate = billDate;
        }

        public final Double getPrice() {
            return this.price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        public BillingRecord build() {
            return new BillingRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BillingRecord> {
        public Builder domainName(String var1);

        public Builder operation(String var1);

        public Builder operation(OperationType var1);

        public Builder invoiceId(String var1);

        public Builder billDate(Instant var1);

        public Builder price(Double var1);
    }
}

