/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest;

public class ListTrafficPolicyInstancesRequestMarshaller
implements Marshaller<Request<ListTrafficPolicyInstancesRequest>, ListTrafficPolicyInstancesRequest> {
    public Request<ListTrafficPolicyInstancesRequest> marshall(ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest) {
        if (listTrafficPolicyInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listTrafficPolicyInstancesRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/trafficpolicyinstances";
        request.setResourcePath(uriResourcePath);
        if (listTrafficPolicyInstancesRequest.hostedZoneIdMarker() != null) {
            request.addParameter("hostedzoneid", StringUtils.fromString((String)listTrafficPolicyInstancesRequest.hostedZoneIdMarker()));
        }
        if (listTrafficPolicyInstancesRequest.trafficPolicyInstanceNameMarker() != null) {
            request.addParameter("trafficpolicyinstancename", StringUtils.fromString((String)listTrafficPolicyInstancesRequest.trafficPolicyInstanceNameMarker()));
        }
        if (listTrafficPolicyInstancesRequest.trafficPolicyInstanceTypeMarkerAsString() != null) {
            request.addParameter("trafficpolicyinstancetype", StringUtils.fromString((String)listTrafficPolicyInstancesRequest.trafficPolicyInstanceTypeMarkerAsString()));
        }
        if (listTrafficPolicyInstancesRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listTrafficPolicyInstancesRequest.maxItems()));
        }
        return request;
    }
}

