/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;

public class ListResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ListResourceRecordSetsRequest>, ListResourceRecordSetsRequest> {
    public Request<ListResourceRecordSetsRequest> marshall(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        if (listResourceRecordSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listResourceRecordSetsRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/rrset";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", listResourceRecordSetsRequest.hostedZoneId());
        request.setResourcePath(uriResourcePath);
        if (listResourceRecordSetsRequest.startRecordName() != null) {
            request.addParameter("name", StringUtils.fromString((String)listResourceRecordSetsRequest.startRecordName()));
        }
        if (listResourceRecordSetsRequest.startRecordTypeAsString() != null) {
            request.addParameter("type", StringUtils.fromString((String)listResourceRecordSetsRequest.startRecordTypeAsString()));
        }
        if (listResourceRecordSetsRequest.startRecordIdentifier() != null) {
            request.addParameter("identifier", StringUtils.fromString((String)listResourceRecordSetsRequest.startRecordIdentifier()));
        }
        if (listResourceRecordSetsRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listResourceRecordSetsRequest.maxItems()));
        }
        return request;
    }
}

