/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;

public class ListHealthChecksIterable
implements SdkIterable<ListHealthChecksResponse> {
    private final Route53Client client;
    private final ListHealthChecksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHealthChecksIterable(Route53Client client, ListHealthChecksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHealthChecksResponseFetcher();
    }

    public Iterator<ListHealthChecksResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<HealthCheck> healthChecks() {
        Function<ListHealthChecksResponse, Iterator> getIterator = response -> {
            if (response != null && response.healthChecks() != null) {
                return response.healthChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListHealthChecksIterable resume(ListHealthChecksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListHealthChecksIterable(this.client, (ListHealthChecksRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListHealthChecksIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListHealthChecksResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListHealthChecksResponseFetcher
    implements SyncPageFetcher<ListHealthChecksResponse> {
        private ListHealthChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListHealthChecksResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListHealthChecksResponse nextPage(ListHealthChecksResponse previousPage) {
            if (previousPage == null) {
                return ListHealthChecksIterable.this.client.listHealthChecks(ListHealthChecksIterable.this.firstRequest);
            }
            return ListHealthChecksIterable.this.client.listHealthChecks((ListHealthChecksRequest)((Object)ListHealthChecksIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

