/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StatusReport
implements ToCopyableBuilder<Builder, StatusReport> {
    private final String status;
    private final Instant checkedTime;

    private StatusReport(BuilderImpl builder) {
        this.status = builder.status;
        this.checkedTime = builder.checkedTime;
    }

    public String status() {
        return this.status;
    }

    public Instant checkedTime() {
        return this.checkedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusReport)) {
            return false;
        }
        StatusReport other = (StatusReport)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.checkedTime(), other.checkedTime());
    }

    public String toString() {
        return ToString.builder((String)"StatusReport").add("Status", (Object)this.status()).add("CheckedTime", (Object)this.checkedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "CheckedTime": {
                return Optional.of(clazz.cast(this.checkedTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant checkedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusReport model) {
            this.status(model.status);
            this.checkedTime(model.checkedTime);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCheckedTime() {
            return this.checkedTime;
        }

        @Override
        public final Builder checkedTime(Instant checkedTime) {
            this.checkedTime = checkedTime;
            return this;
        }

        public final void setCheckedTime(Instant checkedTime) {
            this.checkedTime = checkedTime;
        }

        public StatusReport build() {
            return new StatusReport(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StatusReport> {
        public Builder status(String var1);

        public Builder checkedTime(Instant var1);
    }
}

