/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.services.route53.model.VPCsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListVPCAssociationAuthorizationsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListVPCAssociationAuthorizationsResponse> {
    private final String hostedZoneId;
    private final String nextToken;
    private final List<VPC> vpCs;

    private ListVPCAssociationAuthorizationsResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.nextToken = builder.nextToken;
        this.vpCs = builder.vpCs;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VPC> vpCs() {
        return this.vpCs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpCs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVPCAssociationAuthorizationsResponse)) {
            return false;
        }
        ListVPCAssociationAuthorizationsResponse other = (ListVPCAssociationAuthorizationsResponse)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.vpCs(), other.vpCs());
    }

    public String toString() {
        return ToString.builder((String)"ListVPCAssociationAuthorizationsResponse").add("HostedZoneId", (Object)this.hostedZoneId()).add("NextToken", (Object)this.nextToken()).add("VPCs", this.vpCs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "VPCs": {
                return Optional.of(clazz.cast(this.vpCs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String nextToken;
        private List<VPC> vpCs;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVPCAssociationAuthorizationsResponse model) {
            super(model);
            this.hostedZoneId(model.hostedZoneId);
            this.nextToken(model.nextToken);
            this.vpCs(model.vpCs);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VPC.Builder> getVPCs() {
            return this.vpCs != null ? (Collection)this.vpCs.stream().map(VPC::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC ... vpCs) {
            this.vpCs(Arrays.asList(vpCs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(Consumer<VPC.Builder> ... vpCs) {
            this.vpCs(Stream.of(vpCs).map(c -> (VPC)((VPC.Builder)VPC.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVPCs(Collection<VPC.BuilderImpl> vpCs) {
            this.vpCs = VPCsCopier.copyFromBuilder(vpCs);
        }

        @Override
        public ListVPCAssociationAuthorizationsResponse build() {
            return new ListVPCAssociationAuthorizationsResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, ListVPCAssociationAuthorizationsResponse> {
        public Builder hostedZoneId(String var1);

        public Builder nextToken(String var1);

        public Builder vpCs(Collection<VPC> var1);

        public Builder vpCs(VPC ... var1);

        public Builder vpCs(Consumer<VPC.Builder> ... var1);
    }
}

