/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.services.route53.model.TagResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagsForResourceRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListTagsForResourceRequest> {
    private final String resourceType;
    private final String resourceId;

    private ListTagsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
    }

    public TagResourceType resourceType() {
        return TagResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceRequest)) {
            return false;
        }
        ListTagsForResourceRequest other = (ListTagsForResourceRequest)((Object)obj);
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId());
    }

    public String toString() {
        return ToString.builder((String)"ListTagsForResourceRequest").add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceRequest model) {
            super(model);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForResourceRequest build() {
            return new ListTagsForResourceRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, ListTagsForResourceRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(TagResourceType var1);

        public Builder resourceId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

