/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfig;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfigsCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListQueryLoggingConfigsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListQueryLoggingConfigsResponse> {
    private final List<QueryLoggingConfig> queryLoggingConfigs;
    private final String nextToken;

    private ListQueryLoggingConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.queryLoggingConfigs = builder.queryLoggingConfigs;
        this.nextToken = builder.nextToken;
    }

    public List<QueryLoggingConfig> queryLoggingConfigs() {
        return this.queryLoggingConfigs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLoggingConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueryLoggingConfigsResponse)) {
            return false;
        }
        ListQueryLoggingConfigsResponse other = (ListQueryLoggingConfigsResponse)((Object)obj);
        return Objects.equals(this.queryLoggingConfigs(), other.queryLoggingConfigs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListQueryLoggingConfigsResponse").add("QueryLoggingConfigs", this.queryLoggingConfigs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryLoggingConfigs": {
                return Optional.of(clazz.cast(this.queryLoggingConfigs()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<QueryLoggingConfig> queryLoggingConfigs;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueryLoggingConfigsResponse model) {
            super(model);
            this.queryLoggingConfigs(model.queryLoggingConfigs);
            this.nextToken(model.nextToken);
        }

        public final Collection<QueryLoggingConfig.Builder> getQueryLoggingConfigs() {
            return this.queryLoggingConfigs != null ? (Collection)this.queryLoggingConfigs.stream().map(QueryLoggingConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queryLoggingConfigs(Collection<QueryLoggingConfig> queryLoggingConfigs) {
            this.queryLoggingConfigs = QueryLoggingConfigsCopier.copy(queryLoggingConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryLoggingConfigs(QueryLoggingConfig ... queryLoggingConfigs) {
            this.queryLoggingConfigs(Arrays.asList(queryLoggingConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryLoggingConfigs(Consumer<QueryLoggingConfig.Builder> ... queryLoggingConfigs) {
            this.queryLoggingConfigs(Stream.of(queryLoggingConfigs).map(c -> (QueryLoggingConfig)((QueryLoggingConfig.Builder)QueryLoggingConfig.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueryLoggingConfigs(Collection<QueryLoggingConfig.BuilderImpl> queryLoggingConfigs) {
            this.queryLoggingConfigs = QueryLoggingConfigsCopier.copyFromBuilder(queryLoggingConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListQueryLoggingConfigsResponse build() {
            return new ListQueryLoggingConfigsResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, ListQueryLoggingConfigsResponse> {
        public Builder queryLoggingConfigs(Collection<QueryLoggingConfig> var1);

        public Builder queryLoggingConfigs(QueryLoggingConfig ... var1);

        public Builder queryLoggingConfigs(Consumer<QueryLoggingConfig.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

