/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.model.HealthChecksCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHealthChecksResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListHealthChecksResponse> {
    private final List<HealthCheck> healthChecks;
    private final String marker;
    private final Boolean isTruncated;
    private final String nextMarker;
    private final String maxItems;

    private ListHealthChecksResponse(BuilderImpl builder) {
        super(builder);
        this.healthChecks = builder.healthChecks;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    public List<HealthCheck> healthChecks() {
        return this.healthChecks;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.healthChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthChecksResponse)) {
            return false;
        }
        ListHealthChecksResponse other = (ListHealthChecksResponse)((Object)obj);
        return Objects.equals(this.healthChecks(), other.healthChecks()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListHealthChecksResponse").add("HealthChecks", this.healthChecks()).add("Marker", (Object)this.marker()).add("IsTruncated", (Object)this.isTruncated()).add("NextMarker", (Object)this.nextMarker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HealthChecks": {
                return Optional.of(clazz.cast(this.healthChecks()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<HealthCheck> healthChecks;
        private String marker;
        private Boolean isTruncated;
        private String nextMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHealthChecksResponse model) {
            super(model);
            this.healthChecks(model.healthChecks);
            this.marker(model.marker);
            this.isTruncated(model.isTruncated);
            this.nextMarker(model.nextMarker);
            this.maxItems(model.maxItems);
        }

        public final Collection<HealthCheck.Builder> getHealthChecks() {
            return this.healthChecks != null ? (Collection)this.healthChecks.stream().map(HealthCheck::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder healthChecks(Collection<HealthCheck> healthChecks) {
            this.healthChecks = HealthChecksCopier.copy(healthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthChecks(HealthCheck ... healthChecks) {
            this.healthChecks(Arrays.asList(healthChecks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthChecks(Consumer<HealthCheck.Builder> ... healthChecks) {
            this.healthChecks(Stream.of(healthChecks).map(c -> (HealthCheck)((HealthCheck.Builder)HealthCheck.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHealthChecks(Collection<HealthCheck.BuilderImpl> healthChecks) {
            this.healthChecks = HealthChecksCopier.copyFromBuilder(healthChecks);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListHealthChecksResponse build() {
            return new ListHealthChecksResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, ListHealthChecksResponse> {
        public Builder healthChecks(Collection<HealthCheck> var1);

        public Builder healthChecks(HealthCheck ... var1);

        public Builder healthChecks(Consumer<HealthCheck.Builder> ... var1);

        public Builder marker(String var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextMarker(String var1);

        public Builder maxItems(String var1);
    }
}

