/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.route53.model.GeoLocationDetails;
import software.amazon.awssdk.services.route53.model.GeoLocationDetailsListCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGeoLocationsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListGeoLocationsResponse> {
    private final List<GeoLocationDetails> geoLocationDetailsList;
    private final Boolean isTruncated;
    private final String nextContinentCode;
    private final String nextCountryCode;
    private final String nextSubdivisionCode;
    private final String maxItems;

    private ListGeoLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.geoLocationDetailsList = builder.geoLocationDetailsList;
        this.isTruncated = builder.isTruncated;
        this.nextContinentCode = builder.nextContinentCode;
        this.nextCountryCode = builder.nextCountryCode;
        this.nextSubdivisionCode = builder.nextSubdivisionCode;
        this.maxItems = builder.maxItems;
    }

    public List<GeoLocationDetails> geoLocationDetailsList() {
        return this.geoLocationDetailsList;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextContinentCode() {
        return this.nextContinentCode;
    }

    public String nextCountryCode() {
        return this.nextCountryCode;
    }

    public String nextSubdivisionCode() {
        return this.nextSubdivisionCode;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.geoLocationDetailsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextContinentCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSubdivisionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoLocationsResponse)) {
            return false;
        }
        ListGeoLocationsResponse other = (ListGeoLocationsResponse)((Object)obj);
        return Objects.equals(this.geoLocationDetailsList(), other.geoLocationDetailsList()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.nextContinentCode(), other.nextContinentCode()) && Objects.equals(this.nextCountryCode(), other.nextCountryCode()) && Objects.equals(this.nextSubdivisionCode(), other.nextSubdivisionCode()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListGeoLocationsResponse").add("GeoLocationDetailsList", this.geoLocationDetailsList()).add("IsTruncated", (Object)this.isTruncated()).add("NextContinentCode", (Object)this.nextContinentCode()).add("NextCountryCode", (Object)this.nextCountryCode()).add("NextSubdivisionCode", (Object)this.nextSubdivisionCode()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeoLocationDetailsList": {
                return Optional.of(clazz.cast(this.geoLocationDetailsList()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "NextContinentCode": {
                return Optional.of(clazz.cast(this.nextContinentCode()));
            }
            case "NextCountryCode": {
                return Optional.of(clazz.cast(this.nextCountryCode()));
            }
            case "NextSubdivisionCode": {
                return Optional.of(clazz.cast(this.nextSubdivisionCode()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<GeoLocationDetails> geoLocationDetailsList;
        private Boolean isTruncated;
        private String nextContinentCode;
        private String nextCountryCode;
        private String nextSubdivisionCode;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoLocationsResponse model) {
            super(model);
            this.geoLocationDetailsList(model.geoLocationDetailsList);
            this.isTruncated(model.isTruncated);
            this.nextContinentCode(model.nextContinentCode);
            this.nextCountryCode(model.nextCountryCode);
            this.nextSubdivisionCode(model.nextSubdivisionCode);
            this.maxItems(model.maxItems);
        }

        public final Collection<GeoLocationDetails.Builder> getGeoLocationDetailsList() {
            return this.geoLocationDetailsList != null ? (Collection)this.geoLocationDetailsList.stream().map(GeoLocationDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder geoLocationDetailsList(Collection<GeoLocationDetails> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copy(geoLocationDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocationDetailsList(GeoLocationDetails ... geoLocationDetailsList) {
            this.geoLocationDetailsList(Arrays.asList(geoLocationDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoLocationDetailsList(Consumer<GeoLocationDetails.Builder> ... geoLocationDetailsList) {
            this.geoLocationDetailsList(Stream.of(geoLocationDetailsList).map(c -> (GeoLocationDetails)((GeoLocationDetails.Builder)GeoLocationDetails.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGeoLocationDetailsList(Collection<GeoLocationDetails.BuilderImpl> geoLocationDetailsList) {
            this.geoLocationDetailsList = GeoLocationDetailsListCopier.copyFromBuilder(geoLocationDetailsList);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextContinentCode() {
            return this.nextContinentCode;
        }

        @Override
        public final Builder nextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
            return this;
        }

        public final void setNextContinentCode(String nextContinentCode) {
            this.nextContinentCode = nextContinentCode;
        }

        public final String getNextCountryCode() {
            return this.nextCountryCode;
        }

        @Override
        public final Builder nextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
            return this;
        }

        public final void setNextCountryCode(String nextCountryCode) {
            this.nextCountryCode = nextCountryCode;
        }

        public final String getNextSubdivisionCode() {
            return this.nextSubdivisionCode;
        }

        @Override
        public final Builder nextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
            return this;
        }

        public final void setNextSubdivisionCode(String nextSubdivisionCode) {
            this.nextSubdivisionCode = nextSubdivisionCode;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListGeoLocationsResponse build() {
            return new ListGeoLocationsResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, ListGeoLocationsResponse> {
        public Builder geoLocationDetailsList(Collection<GeoLocationDetails> var1);

        public Builder geoLocationDetailsList(GeoLocationDetails ... var1);

        public Builder geoLocationDetailsList(Consumer<GeoLocationDetails.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextContinentCode(String var1);

        public Builder nextCountryCode(String var1);

        public Builder nextSubdivisionCode(String var1);

        public Builder maxItems(String var1);
    }
}

