/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.route53.model.HealthCheckRegion;
import software.amazon.awssdk.services.route53.model.StatusReport;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HealthCheckObservation
implements ToCopyableBuilder<Builder, HealthCheckObservation> {
    private final String region;
    private final String ipAddress;
    private final StatusReport statusReport;

    private HealthCheckObservation(BuilderImpl builder) {
        this.region = builder.region;
        this.ipAddress = builder.ipAddress;
        this.statusReport = builder.statusReport;
    }

    public HealthCheckRegion region() {
        return HealthCheckRegion.fromValue(this.region);
    }

    public String regionAsString() {
        return this.region;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public StatusReport statusReport() {
        return this.statusReport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReport());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckObservation)) {
            return false;
        }
        HealthCheckObservation other = (HealthCheckObservation)obj;
        return Objects.equals(this.regionAsString(), other.regionAsString()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.statusReport(), other.statusReport());
    }

    public String toString() {
        return ToString.builder((String)"HealthCheckObservation").add("Region", (Object)this.regionAsString()).add("IPAddress", (Object)this.ipAddress()).add("StatusReport", (Object)this.statusReport()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Region": {
                return Optional.of(clazz.cast(this.regionAsString()));
            }
            case "IPAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "StatusReport": {
                return Optional.of(clazz.cast(this.statusReport()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private String ipAddress;
        private StatusReport statusReport;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckObservation model) {
            this.region(model.region);
            this.ipAddress(model.ipAddress);
            this.statusReport(model.statusReport);
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(HealthCheckRegion region) {
            this.region(region.toString());
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getIPAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIPAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final StatusReport.Builder getStatusReport() {
            return this.statusReport != null ? this.statusReport.toBuilder() : null;
        }

        @Override
        public final Builder statusReport(StatusReport statusReport) {
            this.statusReport = statusReport;
            return this;
        }

        public final void setStatusReport(StatusReport.BuilderImpl statusReport) {
            this.statusReport = statusReport != null ? statusReport.build() : null;
        }

        public HealthCheckObservation build() {
            return new HealthCheckObservation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HealthCheckObservation> {
        public Builder region(String var1);

        public Builder region(HealthCheckRegion var1);

        public Builder ipAddress(String var1);

        public Builder statusReport(StatusReport var1);

        default public Builder statusReport(Consumer<StatusReport.Builder> statusReport) {
            return this.statusReport((StatusReport)((StatusReport.Builder)StatusReport.builder().apply(statusReport)).build());
        }
    }
}

