/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHealthCheckRequest
extends Route53Request
implements ToCopyableBuilder<Builder, GetHealthCheckRequest> {
    private final String healthCheckId;

    private GetHealthCheckRequest(BuilderImpl builder) {
        super(builder);
        this.healthCheckId = builder.healthCheckId;
    }

    public String healthCheckId() {
        return this.healthCheckId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckRequest)) {
            return false;
        }
        GetHealthCheckRequest other = (GetHealthCheckRequest)((Object)obj);
        return Objects.equals(this.healthCheckId(), other.healthCheckId());
    }

    public String toString() {
        return ToString.builder((String)"GetHealthCheckRequest").add("HealthCheckId", (Object)this.healthCheckId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HealthCheckId": {
                return Optional.of(clazz.cast(this.healthCheckId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String healthCheckId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckRequest model) {
            super(model);
            this.healthCheckId(model.healthCheckId);
        }

        public final String getHealthCheckId() {
            return this.healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetHealthCheckRequest build() {
            return new GetHealthCheckRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, GetHealthCheckRequest> {
        public Builder healthCheckId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

