/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.route53.model.ChangeAction;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Change
implements ToCopyableBuilder<Builder, Change> {
    private final String action;
    private final ResourceRecordSet resourceRecordSet;

    private Change(BuilderImpl builder) {
        this.action = builder.action;
        this.resourceRecordSet = builder.resourceRecordSet;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public ResourceRecordSet resourceRecordSet() {
        return this.resourceRecordSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecordSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.resourceRecordSet(), other.resourceRecordSet());
    }

    public String toString() {
        return ToString.builder((String)"Change").add("Action", (Object)this.actionAsString()).add("ResourceRecordSet", (Object)this.resourceRecordSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionAsString()));
            }
            case "ResourceRecordSet": {
                return Optional.of(clazz.cast(this.resourceRecordSet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private ResourceRecordSet resourceRecordSet;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            this.action(model.action);
            this.resourceRecordSet(model.resourceRecordSet);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final ResourceRecordSet.Builder getResourceRecordSet() {
            return this.resourceRecordSet != null ? this.resourceRecordSet.toBuilder() : null;
        }

        @Override
        public final Builder resourceRecordSet(ResourceRecordSet resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet;
            return this;
        }

        public final void setResourceRecordSet(ResourceRecordSet.BuilderImpl resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet != null ? resourceRecordSet.build() : null;
        }

        public Change build() {
            return new Change(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Change> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder resourceRecordSet(ResourceRecordSet var1);

        default public Builder resourceRecordSet(Consumer<ResourceRecordSet.Builder> resourceRecordSet) {
            return this.resourceRecordSet((ResourceRecordSet)((ResourceRecordSet.Builder)ResourceRecordSet.builder().apply(resourceRecordSet)).build());
        }
    }
}

