/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.route53domains.model.BillingRecord;
import software.amazon.awssdk.services.route53domains.model.BillingRecordsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ViewBillingResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ViewBillingResponse> {
    private final String nextPageMarker;
    private final List<BillingRecord> billingRecords;

    private ViewBillingResponse(BuilderImpl builder) {
        this.nextPageMarker = builder.nextPageMarker;
        this.billingRecords = builder.billingRecords;
    }

    public String nextPageMarker() {
        return this.nextPageMarker;
    }

    public List<BillingRecord> billingRecords() {
        return this.billingRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextPageMarker() == null ? 0 : this.nextPageMarker().hashCode());
        hashCode = 31 * hashCode + (this.billingRecords() == null ? 0 : this.billingRecords().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewBillingResponse)) {
            return false;
        }
        ViewBillingResponse other = (ViewBillingResponse)((Object)obj);
        if (other.nextPageMarker() == null ^ this.nextPageMarker() == null) {
            return false;
        }
        if (other.nextPageMarker() != null && !other.nextPageMarker().equals(this.nextPageMarker())) {
            return false;
        }
        if (other.billingRecords() == null ^ this.billingRecords() == null) {
            return false;
        }
        return other.billingRecords() == null || other.billingRecords().equals(this.billingRecords());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextPageMarker() != null) {
            sb.append("NextPageMarker: ").append(this.nextPageMarker()).append(",");
        }
        if (this.billingRecords() != null) {
            sb.append("BillingRecords: ").append(this.billingRecords()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextPageMarker;
        private List<BillingRecord> billingRecords = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ViewBillingResponse model) {
            this.setNextPageMarker(model.nextPageMarker);
            this.setBillingRecords(model.billingRecords);
        }

        public final String getNextPageMarker() {
            return this.nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        public final Collection<BillingRecord> getBillingRecords() {
            return this.billingRecords;
        }

        @Override
        public final Builder billingRecords(Collection<BillingRecord> billingRecords) {
            this.billingRecords = BillingRecordsCopier.copy(billingRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingRecords(BillingRecord ... billingRecords) {
            if (this.billingRecords == null) {
                this.billingRecords = new SdkInternalList(billingRecords.length);
            }
            for (BillingRecord e : billingRecords) {
                this.billingRecords.add(e);
            }
            return this;
        }

        public final void setBillingRecords(Collection<BillingRecord> billingRecords) {
            this.billingRecords = BillingRecordsCopier.copy(billingRecords);
        }

        @SafeVarargs
        public final void setBillingRecords(BillingRecord ... billingRecords) {
            if (this.billingRecords == null) {
                this.billingRecords = new SdkInternalList(billingRecords.length);
            }
            for (BillingRecord e : billingRecords) {
                this.billingRecords.add(e);
            }
        }

        public ViewBillingResponse build() {
            return new ViewBillingResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ViewBillingResponse> {
        public Builder nextPageMarker(String var1);

        public Builder billingRecords(Collection<BillingRecord> var1);

        public Builder billingRecords(BillingRecord ... var1);
    }
}

