/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ViewBillingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ViewBillingRequest> {
    private final Date start;
    private final Date end;
    private final String marker;
    private final Integer maxItems;

    private ViewBillingRequest(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public Date start() {
        return this.start;
    }

    public Date end() {
        return this.end;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.start() == null ? 0 : this.start().hashCode());
        hashCode = 31 * hashCode + (this.end() == null ? 0 : this.end().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewBillingRequest)) {
            return false;
        }
        ViewBillingRequest other = (ViewBillingRequest)((Object)obj);
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        if (other.end() != null && !other.end().equals(this.end())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.start() != null) {
            sb.append("Start: ").append(this.start()).append(",");
        }
        if (this.end() != null) {
            sb.append("End: ").append(this.end()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Date start;
        private Date end;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewBillingRequest model) {
            this.setStart(model.start);
            this.setEnd(model.end);
            this.setMarker(model.marker);
            this.setMaxItems(model.maxItems);
        }

        public final Date getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Date start) {
            this.start = StandardMemberCopier.copy((Date)start);
            return this;
        }

        public final void setStart(Date start) {
            this.start = StandardMemberCopier.copy((Date)start);
        }

        public final Date getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Date end) {
            this.end = StandardMemberCopier.copy((Date)end);
            return this;
        }

        public final void setEnd(Date end) {
            this.end = StandardMemberCopier.copy((Date)end);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public ViewBillingRequest build() {
            return new ViewBillingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ViewBillingRequest> {
        public Builder start(Date var1);

        public Builder end(Date var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);
    }
}

